<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('jquery.icheck');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/list_view_appointment.less');
?>
    <div class="view-list-appointment">
        <div class="toolbar">
            <div class="row">
                <div class="col-md-3"><h3><?php esc_attr_e('List appointment','wpbookingpro')?></h3></div>
                <div class="col-md-9">
                    <div class="pull-right">
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="pull-right">
                    <button class="btn btn-primary btn-delete" type="button"><i
                            class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro')?></span></button>
                </div>
            </div>
        </div>
        <div class="wrapper-table-appointment">
            <table class="table table-list-appointment table-responsive">
                <thead>
                <tr class="header table-info">
                    <th></th>
                    <th><?php esc_attr_e('Customer','wpbookingpro')?></th>
                    <th><?php esc_attr_e('Payment','wpbookingpro')?></th>
                    <th><?php esc_attr_e('Status','wpbookingpro')?></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                </tr>
                </thead>
			<?php foreach ($this->list as $item) { ?>
                <tbody>
                <tr class="row-item-order" data-order_id="<?php esc_html_e($item->id) ?>">
                    <td>
                        <div class="wrapper-check-item">
                            <input type="checkbox" class="checkbox-item" name="list_delete_order_id[]" value="<?php esc_html_e($item->id) ?>" />
                        </div>
                    </td>
                    <td><?php esc_html_e($item->customer->customer_full_name) ?></td>
                    <td><?php esc_html_e(WpBookingPro_Helper::format_currency($item->total)); ?></td>
                    <td class="nowrap">
                        <div class="list-order-status">
                            <select class="order-status">
								<?php foreach ($this->list_order_status as $order_status) { ?>
                                    <option <?php echo($order_status->id == $item->order_status_id ? ' selected ' : '') ?>
                                            value="<?php esc_html_e($order_status->id); ?>"><?php esc_html_e($order_status->title); ?></option>
								<?php } ?>
                            </select>
                        </div>
                    </td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td class="show-rate-detail">
                        <i class="fas fa-sort-down"></i>
                    </td>
                </tr>
                <?php if(count($item->list_order_detail))  { ?>
                    <tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>">
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_attr_e('Start time','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('End time','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Assign to','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Service','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Duration','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Location','wpbookingpro')?></th>
                        <td class="nowrap"></td>
                    </tr>
                    <?php foreach ($item->list_order_detail as $order_detail) { ?>
                        <tr class="list-rate-info list-rate-info-<?php esc_attr_e($item->id); ?>">
                            <td class="nowrap"></td>
                            <td class="nowrap">
                                <?php esc_html_e(WpBookingPro_Html::_('date', $order_detail->rate->start_date,
                                    WoobookingText::_('DATETIME_FORMAT_2'))); ?>
                            </td>
                            <td class="nowrap">
                                <?php esc_html_e(WpBookingPro_Html::_('date', $order_detail->rate->end_date,
                                    WoobookingText::_('DATETIME_FORMAT_2'))); ?>
                            </td>
                            <td class="nowrap">
                                <img class="employee-item-image pull-left" src="<?php esc_html_e(Factory::getRootUrlPlugin() . $order_detail->employee_image)  ?>" alt="employee-item-image" />
                                <h4 class="pull-left employee-item-name"><?php esc_html_e($order_detail->employee_full_name); ?></h4>
                            </td>
                            <td class="nowrap"><?php esc_html_e($order_detail->service_name); ?></td>
                            <td class="nowrap"><?php esc_html_e($order_detail->rate->duration) ?></td>
                            <td class="nowrap"><?php esc_html_e($order_detail->location_address); ?></td>
                            <td class="nowrap">
                            </td>
                        </tr>
                    <?php } ?>
                <?php }?>
                </tbody>
			<?php } ?>
        </table>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-list-appointment','list_view_appointment',array(
),'admin/nb_apps/nb_woobooking/assets/js/list_view_appointment.js');