<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_AppointmentModel")) {
    /**
     * Class WpBookingPro_AppointmentModel
     */
    class WpBookingPro_AppointmentModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $context = "appointment";
        /**
         * @var string
         */
        public $table_name = "order";

        /**
         * @return array
         */
        public function getHeader()
        {
            return array();
        }

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $query = $this->db->getQuery(true);
            $query->select('wborder.*')
                ->from($this->getTableName('order') . ' as wborder')
                ->leftJoin($this->getTableName('customer') . ' AS customer ON customer.id=wborder.customer_id')
                ->select('customer.first_name as customer_first_name,customer.last_name as customer_last_name,customer.image as customer_image');
            return $query;
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function getList()
        {
            $list = parent::getList(); // TODO: Change the autogenerated stub
            $query = $this->db->getQuery(true);
            $modelCustomer = WoobookingModel::getInstance('wbcustomer');
            foreach ($list as &$item) {
                $item->full_name = Utility::getFullName($item->customer_first_name, $item->customer_last_name);
                $query->clear()
                    ->select("order_detail.*")
                    ->from($this->getTableName('order_detail') . ' AS order_detail')
                    ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=order_detail.employee_id')
                    ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.image AS employee_image')
                    ->leftJoin($this->getTableName('service') . ' AS service ON service.id=order_detail.service_id')
                    ->select('service.name AS service_name')
                    ->leftJoin($this->getTableName('location') . ' AS location ON location.id=order_detail.location_id')
                    ->select('location.address as location_address')
                    ->where('order_id=' . (int)$item->id);
                $item->list_order_detail = $this->db->setQuery($query)->loadObjectList();
                $list_employee_full_name = [];
                $list_service_name = [];
                foreach ($item->list_order_detail as &$order_detail) {
                    $order_detail->employee_full_name = Utility::getFullName($order_detail->employee_first_name,
                        $order_detail->employee_last_name);
                    $list_employee_full_name[] = $order_detail->employee_full_name;
                    $list_service_name[] = $order_detail->service_name;
                    $query->clear()
                        ->select("*")
                        ->from($this->getTableName('order_detail_rate'))
                        ->where('order_detail_id=' . (int)$order_detail->id);
                    $list_rate = $this->db->setQuery($query)->loadObjectList();
                    foreach ($list_rate as &$rate) {
                        $start_date = Factory::getDate($rate->start_date);
                        $end_date = Factory::getDate($rate->end_date);
                        $since_start = $start_date->diff($end_date);
                        $rate->duration = WoobookingText::_sprintf('TIME_DURATION', $since_start->h, $since_start->i);
                    }
                    $order_detail->rate = reset($list_rate);
                }
                $item->list_employee_full_name = $list_employee_full_name;
                $item->list_service_name = $list_service_name;
            }
            return $list;
        }
    }
}