<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\date\WBDate;
if(!class_exists("WpBookingPro_ViewappModel")) {
    /**
     * Class WpBookingPro_ViewappModel
     */
    class WpBookingPro_ViewappModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "view";
        /**
         * @var string
         */
        public $context = "viewapp";

        /**
         * @param $name
         * @return mixed
         */
        public function getViewByName($name)
        {
            $query = $this->db->getQuery(true);
            $query
                ->select('view.*')
                ->from($this->getTableName('view') . ' AS view')
                ->where('name=' . $query->quote($name));
            return $this->db->setQuery($query)->loadObject();
        }

        /**
         * @param $data
         * @return bool
         */
        public function setup_view($data)
        {
            $list_view = WpBookingPro_Helper::function_get_view();
            foreach ($list_view as $view) {
                $current_view = $this->getViewByName($view->menu_slug);
                if (!$current_view) {
                    $array_view = array(
                        "id" => 0,
                        "name" => $view->menu_slug,
                        "published" => 1
                    );
                    $viewAppModel->save($array_view);
                }
            }
            $views = $data['views'];
            $query = $this->db->getQuery(true);
            $query->update($this->getTableName('view'))
                ->set('published=0');
            $this->db->setQuery($query)->execute();
            $query->clear()
                ->update($this->getTableName('view'))
                ->set('published=1')
                ->where('name in ("' . implode('","', $views) . '")');
            $this->db->setQuery($query)->execute();
            return true;
        }
    }
}