<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CalendarModel")) {
    /**
     * Class WpBookingPro_CalendarModel
     */
    class WpBookingPro_CalendarModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $context = "calendar";
        /**
         * @var string
         */
        public $table_name = "rate";

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->select("rate.*,rate.id as rate_id,rate.from as start,rate.to as end,event.name as title")
                ->from($this->getTableName() . ' as rate')
                ->where('rate.type=' . $query->quote(WpBookingPro_RateHelperAdmin::getEventName()))
                ->innerJoin($this->getTableName('event') . ' as event on event.id=rate.object_id');
            return $query;
        }

        /**
         * @return mixed
         */
        public function getList()
        {
            return $this->db->setQuery($this->getListQuery())->loadObjectList();
        }

        /**
         * @return array
         */
        public function getHeader()
        {
            return array();
        }
    }
}