<?php

defined('_WPBOOKINGPRO_EXEC') or die;
$data = $displayData;

$data['options'] = !empty($data['options']) ? $data['options'] : array();
$noResultsText = '';
$hideActiveFilters = false;
$showFilterButton = false;
$showSelector = false;
$selectorFieldName = isset($data['options']['selectorFieldName']) ? $data['options']['selectorFieldName'] : 'client_id';

if (isset($data['view']->filterForm) && !empty($data['view']->filterForm)) {
	
	if ($selectorField = $data['view']->filterForm->getField($selectorFieldName)) {
		$showSelector = $selectorField->getAttribute('filtermode', '') == 'selector' ? true : $showSelector;
		
		if (isset($data['view']->layout)) {
			$showSelector = $selectorField->getAttribute('layout',
				'default') != $data['view']->layout ? false : $showSelector;
		}
		
		unset($data['view']->activeFilters[$selectorFieldName]);
	}
	
	$filters = $data['view']->filterForm->getGroup('filter');
	$showFilterButton = isset($filters['filter_search']) && count($filters) === 1 ? false : true;
	
	$hideActiveFilters = empty($data['view']->activeFilters);
	
	if (isset($data['view']->total) && (int)$data['view']->total === 0) {
		$noResults = $data['view']->filterForm->getFieldAttribute('search', 'noresults', '', 'filter');
		if (!empty($noResults)) {
			$noResultsText = WoobookingText::_($noResults);
		}
	}
}

$customOptions = array(
	'filtersHidden' => isset($data['options']['filtersHidden']) && $data['options']['filtersHidden'] ? $data['options']['filtersHidden'] : $hideActiveFilters,
	'filterButton' => isset($data['options']['filterButton']) && $data['options']['filterButton'] ? $data['options']['filterButton'] : $showFilterButton,
	'defaultLimit' => isset($data['options']['defaultLimit']) ? $data['options']['defaultLimit'] : Factory::getApplication()->get('list_limit',
		20),
	'searchFieldSelector' => '#filter_search',
	'selectorFieldName' => $selectorFieldName,
	'showSelector' => $showSelector,
	'orderFieldSelector' => '#list_fullordering',
	'showNoResults' => !empty($noResultsText) ? true : false,
	'noResultsText' => !empty($noResultsText) ? $noResultsText : '',
	'formSelector' => !empty($data['options']['formSelector']) ? $data['options']['formSelector'] : '#adminForm',
);

$data['options'] = array_merge($customOptions, $data['options']);

$filtersActiveClass = $hideActiveFilters ? '' : ' js-stools-container-filters-visible';

WpBookingPro_Html::_('searchtools.form', $data['options']['formSelector'], $data['options']);
?>
<div class="js-stools clearfix">
    <div class="clearfix">
		<?php if ($data['options']['showSelector']) : ?>
            <div class="js-stools-container-selector">
			<?php esc_html_e(JLayoutHelper::render('WooBooking.searchtools.default.selector', $data)); ?>
		</div>
		<?php endif; ?>
        <div class="js-stools-container-bar">
			<?php $this->sublayout('bar', $data); ?>
		</div>
        <div class="js-stools-container-list hidden-phone hidden-tablet">
			<?php $this->sublayout('list', $data); ?>
		</div>
    </div>
    <!-- Filters div -->
	<?php if ($data['options']['filterButton']) : ?>
        <div class="js-stools-container-filters hidden-phone clearfix<?php esc_html_e($filtersActiveClass); ?>">
		<?php $this->sublayout('filters', $data); ?>
	</div>
	<?php endif; ?>
</div>
<?php if ($data['options']['showNoResults']) : ?>
	<?php $this->sublayout('noitems', $data); ?>
<?php endif; ?>
