<?php


use Woobooking\CMS\Registry\Registry;

defined('_WPBOOKINGPRO_EXEC') or die;
$list = $displayData['list'];
$pages = $list['pages'];
$options = new Registry($displayData['options']);
$showLimitBox = $options->get('showLimitBox', true);
$showPagesLinks = $options->get('showPagesLinks', true);
$showLimitStart = $options->get('showLimitStart', true);

$currentPage = 1;
$range = 1;
$step = 5;
if (!empty($pages['pages'])) {
	foreach ($pages['pages'] as $k => $page) {
		if (!$page['active']) {
			$currentPage = $k;
		}
	}
}
if ($currentPage >= $step) {
	if ($currentPage % $step === 0) {
		$range = ceil($currentPage / $step) + 1;
	} else {
		$range = ceil($currentPage / $step);
	}
}
?>
<div class="pagination pagination-toolbar clearfix">
    <ul class="pagination pagination-list">
		<?php
		echo LayoutHelper::render('WooBooking.pagination.link', $pages['start']);
		echo LayoutHelper::render('WooBooking.pagination.link', $pages['previous']); ?>
		<?php foreach ($pages['pages'] as $k => $page) : ?>
			<?php $output = LayoutHelper::render('WooBooking.pagination.link', $page); ?>
			<?php if (in_array($k, range($range * $step - ($step + 1), $range * $step), true)) : ?>
				<?php if (($k % $step === 0 || $k === $range * $step - ($step + 1)) && $k !== $currentPage && $k !== $range * $step - $step) : ?>
					<?php $output = preg_replace('#(<a.*?>).*?(</a>)#', '$1...$2', $output); ?>
				<?php endif; ?>
			<?php endif; ?>
			<?php esc_html_e($output); ?>
		<?php endforeach; ?>
		<?php
		echo LayoutHelper::render('WooBooking.pagination.link', $pages['next']);
		echo LayoutHelper::render('WooBooking.pagination.link', $pages['end']); ?>
    </ul>
	<?php if ($showLimitStart) : ?>
        <input type="hidden" name="<?php esc_html_e($list['prefix']); ?>limitstart" value="<?php esc_html_e($list['limitstart']); ?>"/>
	<?php endif; ?>
</div>
