<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$input=Factory::getInput();
$week = array('Monday','Tuesday' ,'Wednesday' ,'Thursday' ,'Friday','Saturday','Sunday');
if(isset($value)) {
    $arr_value= json_decode($value);
} else {
    $arr_value=array();
}

?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> element-field-selectday">
        <?php foreach ($week as $dayName) {?>
            <label class="name-day-of-week">
                <input type='checkbox' class="day-of-week" value="<?php esc_html_e($dayName);?>" <?php echo(in_array($dayName,$arr_value)? 'checked':''); ?>/>
                <?php esc_html_e($dayName);?>
            </label>
        <?php }?>
        <input type="hidden" name="<?php esc_html_e($name);?>">
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.icheck');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/selectday/selectday.less');
$doc->addScriptApplySelector('.element-field-selectday','field_selectday',array(
        'input_name'=>$name,
        'value'=>$arr_value
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/selectday/selectday.jquery.js');
