(function ($) {
    $.field_pickdatetime = function (element, options) {
        var defaults = {
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            var array = ["2013-03-14", "2013-03-15", "2013-03-16"];
            var $select_date_time = $element.find('.select-date-time');
            $select_date_time.datepicker({
                altField: "#alternate",
                altFormat: "DD, d MM, yy",
                
                beforeShowDay: function (date) {
                    var string = jQuery.datepicker.formatDate('yy-mm-dd', date);
                    return [true, `date-${string}`];
                },
                onSelect: function (date, instant) {
                    var data_post = {
                        task: "event.ajax_get_rang_time_avail",
                        date: date,
                        event_id: plugin.settings.event_id
                    };
                    setTimeout(function () {
                        $.ajax({
                            type: "POST",
                            dataType: "json",
                            url: wpbookingpro_root_url + wpbookingpro_api_task,
                            contentType: "application/json; charset=utf-8",
                            data: JSON.stringify(data_post),
                            beforeSend: function () {
                                
                            },
                            error: function (xhr) { 
                                $.alert({
                                    title: 'Error',
                                    content: 'there are some error please contact admin !',
                                });
                            },
                            complete: function () {
                            },
                            success: function (response) {
                                response = JSON.parse(response);
                                if (response.result === "success") {
                                    var data = response.data;
                                    let times = [];
                                    $.each(data, function (index, time) {
                                        times.push(`<label class="time btn btn-info btn-sm">${time[0]}-${time[1]}</label>`);
                                    });
                                    times = times.join('');
                                    var monment_date = moment(date);
                                    var date_item = monment_date.format('YYYY-MM-DD');
                                    var $td = $select_date_time.find(`td.date-${date_item}`);
                                    var $tr = $td.closest('tr');
                                    var $insert_tr = $(`<tr><td colspan="8"><div class="list-range-time">${times}</div></td></tr>`);
                                    $insert_tr.insertAfter($tr);
                                    $insert_tr.find('label.time').click(function (e) {
                                        $insert_tr.find('label.time').removeClass('btn-success').addClass('btn-info');
                                        $(this).removeClass('btn-info').addClass('btn-success');
                                    });
                                }
                            }
                        });
                    }, 1000);
                },
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_pickdatetime = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_pickdatetime')) {
                var plugin = new $.field_pickdatetime(this, options);
                $(this).data('field_pickdatetime', plugin);
            }
        });
    }
})(jQuery);