<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> element-field-opentime">
        <input type="text" id="open-time" class="form-control open-time" value="<?php esc_html_e($value);?>" />
        <input type="hidden" name="<?php esc_html_e($name);?>" />
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.moment');
WpBookingPro_Html::_('jquery.daterangepicker');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/opentime/opentime.less');
$doc->addScriptApplySelector('.element-field-opentime','field_opentime',array(
        'input_name'=>$name,
        'value'=>$value
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/opentime/opentime.jquery.js');
