<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.icheck');
WpBookingPro_Html::_('jquery.moment');
WpBookingPro_Html::_('jquery.fontawesome');
WpBookingPro_Html::_('jquery.daterangepicker');
WpBookingPro_Html::_('jquery.ui');
$doc = Factory::getDocument();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$input=Factory::getInput();
$event_id=$input->getInt('id',0);
if($event_id > 0) {
    $modelEvent = WoobookingModel::getInstance('event');
    $event=$modelEvent->getItem($event_id);
    $open_date = Factory::getDate($event->open_date);
    if (!$open_date->getTimestamp()) {
        $open_date = clone Factory::getDate();
    }
    $open_date = $open_date->toSql();
}
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> element-field-open-date <?php echo($open_date?'hide-option':'');?> field-opendate-<?php esc_html_e($name_format) ?> field-opendate">
        <label class="label">
            <input type="checkbox" class="opendate-ckb"  name="<?php esc_html_e($name); ?>" value="1" <?php echo($open_date?'':'checked');?> /><span><?php esc_attr_e('Booking open immediately','wpbookingpro')?></span>
        </label>
        <div class="option form-horizontal <?php echo($open_date?'invisible':'');?>">
            <div class="form-group">
                <label for="until-when" class="col-sm-3 control-label"><?php esc_attr_e('Open on','wpbookingpro') ?>:</label>
                <div class="col-sm-9">
                    <input type="text" class="form-control open-date" id="open-date" value="<?php echo($open_date ? $open_date : '') ?>" />
                    <input type="hidden"  name="<?php esc_html_e($name_open_date) ?>" />
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/opendate.less');
$doc->addScriptApplySelector('.element-field-open-date','field_opendate',array(
        "input_name"=>$name_open_date
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/opendate.jquery.js');
