(function ($) {
    $.field_opendate = function (element, options) {
        var defaults = {
            tags: [],
            input_name: ''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);

            let name_close_date = plugin.settings.name_close_date;
            $element.find('.opendate-ckb').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            }).on('ifChanged ', function(event) {
                if (!$(this).is(':checked')) {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                } else {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                }
            });
            $element.find('.label').click(function (e) {
                if ($(this).find('input[type="checkbox"]').is(':checked')) {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                } else {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                }
            });
            $element.find('input[id="open-date"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                timePicker: true,
                minYear: 1901,
                locale: {
                    format: 'YYYY-MM-DD HH:mm:ss'
                },
                maxYear: '+10',
                isInvalidDate: function(date) {
                    if (date.format('YYYY-MM-DD') < moment().format('YYYY-MM-DD')) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name['0']}"]`).val(start.format('YYYY-MM-DD HH:mm:ss'));
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_opendate = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_opendate')) {
                var plugin = new $.field_opendate(this, options);
                $(this).data('field_opendate', plugin);
            }
        });
    }
})(jQuery);
