<?php

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete == ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	!empty($onchange) ? 'onchange="' . $onchange . '"' : '',
	isset($max) ? 'max="' . $max . '"' : '',
	!empty($step) ? 'step="' . $step . '"' : '',
	isset($min) ? 'min="' . $min . '"' : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? 'autofocus' : ''
);
if (is_numeric($value)) {
	$value = (float)$value;
} else {
	$value = '';
	$value = ($required && isset($min)) ? $min : $value;
}

?>
<input type="number" id="<?php
esc_html_e($id); ?>" name="<?php
esc_html_e($name); ?>"
       value="<?php esc_html_e(htmlspecialchars($value, ENT_COMPAT, 'UTF-8')); ?>" <?php echo(implode(' ',
	$attributes)); ?> />
