<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.tooltip');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.increment');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-map">
        <div class="row">
            <div class="col-md-12">
                <div id="simplegmaps-<?php esc_html_e($name); ?>" class="google-map simplegmaps-google">
                    <div class="map-marker" data-title="Remi" data-latlng="20.9436294,105.7960543"
                         data-address=""></div>
                </div>
                <button type="submit" style="display: none;" id="search-<?php esc_html_e($name); ?>"></button>
                <input type="hidden" name="<?php esc_html_e($field_published); ?>" value="1" />
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <p><?php esc_attr_e_('You have coodinate?','wpbookingpro') ?></p>
                <div class="coodinate-<?php esc_html_e($name); ?>" style="display: none;">
                    <div class="coodinate">
                        <label><?php esc_attr_e_('Latitude','wpbookingpro') ?>:</label>
                        <input type="text" />
                    </div>
                    <div class="coodinate">
                        <label><?php esc_attr_e_('Longtitude','wpbookingpro') ?>:</label>
                        <input type="text" />
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-map','field_map',array(
    "input_name"=>  $name,
    "listen_onchange_address_name"=>  $listen_onchange_address_name,
    "field_published"=>  $field_published,
    "eventButton"=>  $name,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/map.jquery.js');