<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.ui');
$doc = Factory::getDocument();
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$name_title = $data->def('name');
$arrName = explode(' ', $name_title);
$iconImg = '';
for ($i = 0; $i < 3; $i++) {
	$iconImg .= substr($arrName[$i], 0, 1);
}
$iconImg = strtoupper($iconImg);
$images = $value;
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-gallery hide-option">
        <ul class="list-image">
			<?php foreach ($images as $image) { ?>
                <li data-id="<?php esc_html_e($image->id); ?>" class="image-item">
                    <i class="far fa-trash-alt remove"></i>
                    <img class="image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($image->path); ?>" alt="image-item" />
                </li>
			<?php } ?>
            <li>
                <div class="upload"><i class="far fa-plus-square"></i></div>
            </li>
        </ul>
		<?php if ($enable_upload) { ?>
            <input type="file" class="upload upload-file item-image" style="display: none"/>
		<?php } else { ?>
            <div class="btn-browser-media"></div>
		<?php } ?>
        <input type="hidden" class="deleted" name="<?php esc_html_e($name_field_deleted) ?>" style="display: none" />
    </div>
<?php
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/gallery.less');
$doc->addScriptApplySelector('.field-gallery','field_gallery',array(
    "input_name"=>  $name,
    "name_field_deleted"=>  $name_field_deleted,
    "enable_upload"=>  (boolean)$enable_upload,
    "multiple"=>  (boolean)$multiple,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/gallery.jquery.js');