<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$a_title = $data->def('name');
$fullname = ucwords($data->def('first_name') . ' ' . $data->def('last_name'));
$image = $data->def('image_location_avatar');
$a_title = Utility::clean($a_title);
$a_title = Utility::clean_all_space_to_single_space($a_title);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-fullimage">
        <div class="wrapper-field-fullimage">
            <div class="header">
                <i class="far fa-plus-square upload"></i>
                <div>
                    <img class="img-fullimage" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($value ? $value : $default) ?>" alt="img-fullimage" />
                </div>
            </div>
            <input type="file" class="upload"  name="<?php esc_html_e($name); ?>" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/fullimage.less');
$doc->addScriptApplySelector('.field-fullimage','field_fullimage',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/fullimage.jquery.js');