<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.increment');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_color = [
	'#e6194b',
	'#3cb44b',
	'#ffe119',
	'#4363d8',
	'#f58231',
	'#911eb4',
	'#46f0f0',
	'#f032e6',
	'#bcf60c',
	'#fabebe',
	'#008080',
	'#e6beff',
	'#9a6324',
	'#fffac8',
	'#800000',
	'#aaffc3',
	'#808000',
	'#ffd8b1',
	'#000075',
	'#808080',
	'#ffffff',
	'#000000'
];
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-colorpicker">
        <ul class="list-color">
			<?php foreach ($list_color as $color) { ?>
                <li>
                    <div class="color-item <?php echo($value == $color ? ' active ' : '') ?>"
                         data-color="<?php esc_html_e($color) ?>" style="background: <?php esc_html_e($color) ?>"><i
                                class="fas fa-check checked"></i></div>
                </li>
			<?php } ?>
        </ul>
        <input type="hidden" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-colorpicker','field_colorpicker',array(
    "input_name"=>  $name
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/colorpicker.jquery.js');