(function ($) {
    $.field_closetime = function (element, options) {
        var defaults = {
            input_name: "",
            value:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let value=plugin.settings.value;
            $(`input[name="${plugin.settings.input_name}"]`).val(value);
            $element.find('#close-time').daterangepicker({
                singleDatePicker: true,
                datePicker: false,
                timePicker: true,
                timePicker24Hour: false,
                timePickerIncrement: 10,
                locale: {
                    format: 'LT'
                }
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name}"]`).val(start.format('HH:mm:ss'));
            }).on('show.daterangepicker', function (ev, picker) {
                picker.container.find(".calendar-table").hide();
            });;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_closetime = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_closetime')) {
                var plugin = new $.field_closetime(this, options);
                $(this).data('field_closetime', plugin);
            }
        });
    }
})(jQuery);