<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$input=Factory::getInput();
$event_id=$input->getInt('id',0);
if($event_id > 0) {
    $modelEvent = WoobookingModel::getInstance('event');
    $event=$modelEvent->getItem($event_id);
    $close_date = Factory::getDate($event->close_date);
    if (!$close_date->getTimestamp()) {
        $close_date = clone Factory::getDate();
    }
    $close_date = $close_date->toSql();
}
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> element-field-close-date <?php echo($close_date?'hide-option':'');?>">
        <label class="label"><input type="checkbox" class="recurring" name="<?php esc_html_e($name); ?>" value="1" <?php echo($close_date?'':'checked');?> /><span><?php esc_attr_e('Booking closes when event starts','wpbookingpro')?></span></label>
        <div class="option form-horizontal <?php echo($close_date?'invisible':'');?>">
            <div class="form-group">
                <label for="until-when" class="col-sm-3 control-label"><?php esc_attr_e('Closes on','wpbookingpro') ?>:</label>
                <div class="col-sm-9">
                    <input type="text" id="close-date" class="form-control close-date" value="<?php echo($close_date ? $close_date : '') ?>" />
                    <input type="hidden" name="<?php esc_html_e(esc_attr($name_close_date)); ?>" />
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('jquery.daterangepicker');
WpBookingPro_Html::_('jquery.icheck');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/closedate.less');
$doc->addScriptApplySelector('.element-field-close-date','field_closedate',array(
        "input_name"=>$name_close_date
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/closedate.jquery.js');
