<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.auto_numeric');
WpBookingPro_Html::_('jquery.base64');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.increment');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$modelServices = WoobookingModel::getInstance('services');
$list_category_and_service = $modelServices->getListServiceCategory();
$list_service_selected_by_employee = $value;
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-assignedservices">
        <table class="table">
			<?php foreach ($list_category_and_service as $category_and_service) { ?>
				<?php if (count($category_and_service->list_service)) { ?>
                    <thead>
                    <tr>
                        <th><input type="checkbox" /></th>
                        <th><?php esc_html_e($category_and_service->name); ?></th>
                        <th><?php esc_attr_e('Price','wpbookingpro') ?></th>
                        <th><?php esc_attr_e('Capacity','wpbookingpro') ?></th>
                    </tr>
                    </thead>
                    <tbody>
					<?php foreach ($category_and_service->list_service as $service) { ?>
						<?php
						$customize_service = $list_service_selected_by_employee[$service->id];
						$checked = ($customize_service && $customize_service->enable_customize) ? true : false;
						?>
                        <tr class="category-and-service" data-service_id="<?php esc_html_e($service->id); ?>">
                            <td><input type="checkbox" class="enable-customize" <?php echo($checked ? ' checked ' : '') ?> /></td>
                            <td><?php esc_html_e($service->name); ?></td>
                            <td><input type="text" class="form-control price" data-a-sign="$" value="<?php echo($checked ? $customize_service->price : $service->price) ?>" />
                            </td>
                            <td>
                                <input type="text" class="form-control minimum_capacity pull-left" <?php echo($checked ? '' : ' disabled') ?> value="<?php esc_html_e($checked ? $customize_service->minimum_capacity : $service->minimum_capacity) ?>" />
                                <input type="text" class="form-control maximum_capacity pull-left" <?php echo($checked ? '' : ' disabled') ?> value="<?php esc_html_e($checked ? $customize_service->maximum_capacity : $service->maximum_capacity) ?>" />
                            </td>
                        </tr>
					<?php } ?>
                    </tbody>
				<?php } ?>
			<?php } ?>
        </table>
        <input type="hidden" name="<?php esc_html_e($name); ?>" />
    </div>
<?php
$list_employee_service = $value;
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/assignedservices.less');
$doc->addScriptApplySelector('.field-assignedservices','field_assignedservices',array(
    "input_name"=>  $name,
    "list_employee_service"=>  $list_employee_service,
    "wpbookingpro_root_url"=>  Factory::getRootUrlPlugin(),
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/js/assignedservices.jquery.js');