<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Filesystem\File;
use WooBooking\CMS\Filesystem\Folder;
use WooBooking\CMS\OpenSource\WordPress\WooBookingOnWordpress;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_ToolController")) {
    /**
     * Class WpBookingPro_ToolController
     */
    class WpBookingPro_ToolController extends woobooking_controller
    {
        /**
         * @return mixed
         * @throws Exception
         */
        public function next()
        {
            $input = Factory::getInput();
            $tool = $input->get('tool', array(), 'array');
            return $this->view("tool.form");
        }

        /**
         * @return bool
         */
        public function setup_sample_database()
        {
            return true;
        }

        /**
         * @return bool
         */
        public function setup_sample_page()
        {
            return WooBookingOnWordpress::pluginprefix_activation();
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function create_view()
        {
            return $this->view("tool.create_view");
        }

        /**
         *
         */
        public function download_package()
        {
            $path = WPBOOKINGPRO_PATH_ROOT;
            $list = array();
            $exclude = array(
                '.DS_Store',
                '.git',
                '.idea',
                '.gitignore',
                'lib',
                'Licensing',
                'wpbookingpro.zip',
                'resources',
                'admin/resources',
                'upload',
                'note.txt',
                'note_android.txt',
                'note_function_wc.txt',
                'son_note.txt',
                'dev_tut'
            );
            $filter = array(
                'php',
                'js',
                'xml',
                'jpg',
                'png',
                'gif',
                'html',
                'json',
                'less',
                'css',
                'ini',
                'pot',
                'md',
                'eot',
                'svg',
                'ttf',
                'woff'
            );
            $app = Factory::getApplication();
            $db = Factory::getDBO();
            $list_table_in_database = $db->setQuery("SHOW TABLES LIKE " . $db->quote("woobooking\\_%"))->loadColumn();


            $pattern = '/(?:(?:\/\*(?:[^*]|(?:\*+[^*\/]))*\*+\/)|(?:(?<!\:|\\\|\')\/\/.*))/';
            WpBookingPro_Helper::getDirContents($path, $list, $exclude, $filter);
            # create new zip object
            $zip_plugin = new ZipArchive();
            $file_zip_plugin_name = "wpbookingpro.zip";
            # create a temp file & open it
            $short_folder_plugin_path = "tmp/plugin";
            $short_zip_plugin_path = "$short_folder_plugin_path/$file_zip_plugin_name";
            $full_path_file_zip_plugin = WPBOOKINGPRO_PATH_ROOT . DS . $short_zip_plugin_path;
            $zip_plugin->open($full_path_file_zip_plugin, (ZipArchive::CREATE | ZipArchive::OVERWRITE));
            # loop through each file
            foreach ($list as $file) {
                if (!is_dir($file)) {
                    $file_content = File::read($file);
                    $extension = File::getExt($file);
                    if (strpos($file, "nb_config.php") !== false) {
                        $pattern_tool = '/(\$environment)(.*)(development)(.*)/';
                        $matches = array();
                        preg_match($pattern_tool, $file_content, $matches);
                        $first = array_shift($matches);
                        $file_content = str_replace($first, "$matches[0]$matches[1]production$matches[3]", $file_content);

                        $pattern_tool = '/(\$live_site)(.*)/';
                        $matches = array();
                        preg_match($pattern_tool, $file_content, $matches);
                        $first = array_shift($matches);
                        $file_content = str_replace($first, "$matches[0]=\"\";", $file_content);
                    }
                    if ($extension == "php") {

                    }

                    $zip_plugin->addFromString(Utility::get_path_file($file), $file_content);
                }
            }
            $list_include_folder = array(
                "lib",
                "admin/resources",
                "resources",
            );
            foreach ($list_include_folder as $folder) {
                $zip_plugin->addEmptyDir($folder);
                $source = realpath(WPBOOKINGPRO_PATH_ROOT . DS . $folder);
                if (is_dir($source) === true) {
                    WpBookingPro_Helper::getDirContents($source, $files, array(), array());
                    foreach ($files as $file) {
                        if (!is_dir($file)) {
                            $zip_plugin->addFile($file, Utility::get_path_file($file));
                        }
                    }
                }
            }
            $zip_plugin->addEmptyDir('upload');
            $zip_plugin->addFromString('upload/index.html', "");
            $file_plugin = WPBOOKINGPRO_PATH_ROOT . DS . 'wpbookingpro.php';
            $file_content = File::read($file_plugin);
            preg_match_all($pattern, $file_content, $matches);
            $matches = reset($matches);
            array_shift($matches);
            $file_content = str_replace($matches, "\r\n", $file_content);
            $zip_plugin->addFromString(Utility::get_path_file($file_plugin), $file_content);
            //add file install
            $install_file = "create_table.sql";
            $file_install_path = WPBOOKINGPRO_PATH_ROOT . DS . "install/$install_file";
            $file_install_content = File::read($file_install_path);
            $file_install_content = base64_encode($file_install_content);
            $zip_plugin->addFromString("lib/vendor/netbaseteam/woobooking/src/database_sample/base_64_$install_file", $file_install_content);
            //add file install sample data
            $install_file = "example_data.sql";
            $file_install_path = WPBOOKINGPRO_PATH_ROOT . DS . "install/$install_file";
            $file_install_content = File::read($file_install_path);
            $file_install_content = base64_encode($file_install_content);
            $zip_plugin->addFromString("lib/vendor/netbaseteam/woobooking/src/database_sample/base_64_$install_file", $file_install_content);
            $root_url = Factory::getRootUrlPlugin();
            # close zip
            $zip_plugin->close();

            //zip to main file
            $config = Factory::getConfig();
            $version = $config->get('version', '1.0');

            $main_files_zip = "MainFiles_v$version.zip";
            $short_main_files_zip_path = "tmp/$main_files_zip";
            $zip_main_file = new ZipArchive();
            # create a temp file & open it
            $main_files_full_path = WPBOOKINGPRO_PATH_ROOT . DS . $short_main_files_zip_path;

            $zip_main_file->open($main_files_full_path, (ZipArchive::CREATE | ZipArchive::OVERWRITE));


            $zip_main_file->addFile(WPBOOKINGPRO_PATH_ROOT . DS . "changelog.txt", "changelog.txt");
            $zip_main_file->addEmptyDir("Main_files");
            $zip_main_file->addFile($full_path_file_zip_plugin, "Main_files" . DS . $file_zip_plugin_name);
            $zip_main_file->addEmptyDir("Main_files/Licensing");
            //add folder Licensing
            $full_path_folder_licensing = WPBOOKINGPRO_PATH_ROOT . DS . "Licensing/";
            if (is_dir($full_path_folder_licensing) === true) {
                $files = Folder::files($full_path_folder_licensing);
                foreach ($files as $file) {
                    $zip_main_file->addFile($full_path_folder_licensing . DS . $file, "Main_files/Licensing/" . $file);
                }
            }
            $zip_main_file->close();
            Utility::redirect($root_url . "tmp/$main_files_zip");
        }

        /**
         * @param string $content
         * @return string|string[]|null
         */
        static function remove_html_comments($content = '')
        {
            return preg_replace('/<!--(.|\s)*?-->/', "\r\n", $content);
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function setup_view()
        {
            return $this->view("tool.setup_view");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function create_sample_data_order()
        {
            return $this->view("tool.create_sample_data_order");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function list_page_front_end()
        {
            return $this->view("tool.list_page_front_end");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function create_sample_data()
        {
            return $this->view("tool.create_sample_data");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function save_setup_view()
        {
            $input = Factory::getInput();
            $data = $input->getData();
            $viewAppModel = WoobookingModel::getInstance('viewapp');
            $viewAppModel->setup_view($data);
            return $this->view("tool.setup_view");
        }
    }
}
?>