<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_BlockController")) {
    /**
     * Class WpBookingPro_BlockController
     */
    class WpBookingPro_BlockController extends woobooking_controller
    {
        /**
         * @return mixed
         */
        public function ajax_get_preview_blog()
        {
            $input = Factory::getInput();
            $type = $input->getString('type', "");
            list($view, $layout) = explode("-", $type);
            return include WPBOOKINGPRO_PATH_ROOT . DS . "blocks/block_bookingtraining/bookingtraining.php";
        }

        /**
         * @return array|bool|mixed
         * @throws Exception
         */
        public function ajax_save_block()
        {
            $input = Factory::getInput();
            $data = $input->getData();
            $data['params'] = json_encode($data['params']);
            $blockModel = WoobookingModel::getInstance('block');
            $block = $blockModel->save($data);
            return $block;
            $data_param = $block->params;
            foreach ($data_param as $key => $value) {
                $input->set($key, $value);
            }
            $type = $input->getString('type', "");
            list($view, $layout) = explode("-", $type);
            return $this->view("$view.$layout");
        }

        /**
         * @return false|mixed|string
         * @throws Exception
         */
        public function ajax_get_config_blog()
        {
            $input = Factory::getInput();
            $modelBlock = WoobookingModel::getInstance('block');
            $id = $input->getInt('id', 0);
            $type = $input->get('type', '');
            if (!$id) {
                $block = $modelBlock->createNewBlock($type);
                $input->set('block_id', $block->id);
            }
            if (strpos($type, '-block-') !== false) {
                list($package, $block, $block_name) = explode("-", $type);
                return $this->config_block($block_name);
            } else {
                list($package, $view, $layout) = explode("-", $type);
                return $this->view_config_block_app("$view.config_$layout");
            }
        }

        /**
         * @param $layout
         * @return mixed
         * @throws Exception
         */
        public static function view_config_block_app($layout)
        {
            list($view, $tpl) = explode(".", $layout);
            $view_path = WPBOOKINGPRO_PATH_COMPONENT . "/views/$view/view.html.php";
            if (file_exists($view_path)) {
                require_once $view_path;
                $UFCiew = ucfirst($view);
                $view_name = "WpBookingPro_{$UFCiew}View";
                $view_class = new $view_name();
                $view_class->view = $view;
                return $view_class->view_config_block_app($tpl);
            } else {
                throw new Exception("Error: view <b>$view_path</b> not exists please create it");
            }
        }

        /**
         * @param $block_name
         * @param null $config_layout
         * @return false|string
         * @throws Exception
         */
        public static function config_block($block_name, $config_layout = null)
        {
            $block_view_path = WPBOOKINGPRO_PATH_COMPONENT_FRONT_END . "/views/block/view.html.php";
            if (file_exists($block_view_path)) {
                require_once $block_view_path;
                $view_class = new WpBookingPro_BlockView();
                $view_class->view = "block";
                return $view_class->display_config_block($block_name);
            } else {
                throw new Exception("Error: view <b>$block_view_path</b> not exists please create it");
            }
        }

        /**
         * @param $block_id
         * @param $layout
         * @return false|string
         * @throws Exception
         */
        public static function display_block($block_id, $layout)
        {
            $blockModel = WoobookingModel::getInstance('block');
            $block = $blockModel->getItem($block_id);
            $block_view_path = WPBOOKINGPRO_PATH_COMPONENT_FRONT_END . "/views/block/view.html.php";
            if (file_exists($block_view_path)) {
                require_once $block_view_path;
                $view_class = new WpBookingPro_BlockView();
                $view_class->view = "block";
                return $view_class->display_block($block_name);
            } else {
                throw new Exception("Error: view <b>$block_view_path</b> not exists please create it");
            }
            list($view, $tpl) = explode(".", $layout);
            $view_path = WPBOOKINGPRO_PATH_COMPONENT . "/views/$view/view.html.php";
            if (file_exists($view_path)) {
                require_once $view_path;
                $UFCiew = ucfirst($view);
                $view_name = "WpBookingPro_{$UFCiew}View";
                $view_class = new $view_name();
                $view_class->view = $view;
                return $view_class->display_block($block, $tpl);
            } else {
                throw new Exception("Error: view <b>$view_path</b> not exists please create it");
            }
        }
    }
}