"use strict";
(function ($) {
    $.view_list_wbcustomer = function (element, options) {
        var defaults = {
            class_name_drawerel: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $class_name_drawerel = plugin.settings.class_name_drawerel;
            $wooBooking.set_class_name_drawerel($class_name_drawerel);
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.btn-add-new').click(function (e) {
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "wbcustomer.ajax_get_item"
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "wbcustomer.ajax_save");
                            $wooBooking.getDrawer().drawer('toggle');
                            $wooBooking.getDrawer().find('h4.title').html('Add new wbcustomer');
                            $('.view-wbcustomer-form').find('.wbcustomer-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.wbcustomer-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        }
                    }
                });
            });
            $element.find('.btn-customer-edit').live('click', function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "wbcustomer.get_wbcustomer_by_id",
                        id: id
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "wbcustomer.ajax_save");
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                            $wooBooking.getDrawer().drawer('toggle');
                            $wooBooking.getDrawer().find('h4.title').html(`Edit wbcustomer: ${id}`);
                            $('.view-wbcustomer-form').find('.wbcustomer-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.wbcustomer-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        } else {
                            $.alert({
                                title: 'Error',
                                content: response.msg
                            });
                        }
                    }
                });
            });
            $element.find('.checked-all').click(function (e) {
                $('table.list-wbcustomer').find('.checkbox-item').prop('checked', $(this).is(':checked'));
            });
            $('table.list-wbcustomer').find('.checkbox-item').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-wbcustomer').find('.checkbox-item');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            $element.find('.btn-add-new').click(function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        action: "get_data",
                        id: id
                    },
                    success: function (response) {
                        $wooBooking.getDrawer().find('.hy-drawer-content').html(response);
                        $wooBooking.getDrawer().drawer('toggle');
                        $('.view-wbcustomer-form').find('.wbcustomer-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                        })
                        location.reload(true);
                    }
                });
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_wbcustomer_id = [];
                $element.find('.delete-wbcustomer:checked').each(function (e) {
                    list_delete_wbcustomer_id.push($(this).val());
                });
                if (list_delete_wbcustomer_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose customer before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this customer ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "wbcustomer.ajax_delete",
                                    list_delete_wbcustomer_id: list_delete_wbcustomer_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $wooBooking.call_back_when_save_success = function (data, is_new) {
                location.reload(true);
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_wbcustomer = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_wbcustomer')) {
                var plugin = new $.view_list_wbcustomer(this, options);
                $(this).data('view_list_wbcustomer', plugin);
            }
        });
    }
})(jQuery);
