"use strict";
jQuery(document).ready(function ($) { 
    $('.view-list-finance').find('input[type="checkbox"]').iCheck({
        checkboxClass: 'icheckbox_square-red',
        radioClass: 'iradio_square-red',
        increaseArea: '20%'
    });
    $('.wrapper-finance-item').find('.arrow-detail-finance').click(function (e) {
        $(this).closest('.wrapper-finance-item').next().toggle("slow", function () {
        });
    })
    $('.btn-add-finance').click(function (e) {
        e.preventDefault();
        $wooBooking.getDrawer().drawer('toggle');
    });
    $('.btn-edit-order').click(function (e) {
        e.preventDefault();
        $wooBooking.getDrawer().drawer('toggle');
    });
    $('.pagination-list-finance').twbsPagination({
        totalPages: 35,
        visiblePages: 7,
        onPageClick: function (event, page) {
            $('#page-content').text('Page ' + page);
        }
    });
    $('.view-list-finance').find('.btn-add-new').click(function (e) {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: wpbookingpro_root_url + wpbookingpro_api_task,
            data: {
                task: "finance.ajax_get_item"
            },
            beforeSend: function () {
                $('body').loadingModal();
            },
            error: function (xhr) {
                $.alert({
                    title: 'Error',
                    content: 'there are some error please contact admin !',
                });
            },
            complete: function () {
                $('body').loadingModal('destroy');
            },
            success: function (response) {
                response = JSON.parse(response);
                if (response.result === "success") {
                    loadScripts(response);
                    $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                    $('body').append(response.data_script);
                    $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "finance.ajax_save");
                    $wooBooking.getDrawer().drawer('toggle');
                    $wooBooking.getDrawer().find('h4.title').html('Add new finance');
                    $('.view-finance-form').find('.finance-tab a').on('click', function (e) {
                        e.preventDefault();
                        $(this).tab('show')
                        $('.finance-tab a').removeClass('active');
                        $(this).addClass('active');
                    });
                }
            }
        });
    });
    $('.view-list-finance').find('.btn-edit-finance').live('click', function (e) {
        var id = $(this).data('id');
        $.ajax({
            type: "POST",
            dataType: "json",
            url: wpbookingpro_root_url + wpbookingpro_api_task,
            data: {
                task: "finance.ajax_get_item",
                id: id
            },
            beforeSend: function () {
                $('body').loadingModal();
            },
            error: function (xhr) {
                $.alert({
                    title: 'Error',
                    content: 'there are some error please contact admin !',
                });
            },
            complete: function () {
                $('body').loadingModal('destroy');
            },
            success: function (response) {
                response = JSON.parse(response);
                if (response.result === "success") {
                    loadScripts(response);
                    $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                    $('body').append(response.data_script);
                    $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "finance.ajax_save");
                    $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                    $wooBooking.getDrawer().drawer('toggle');
                    $('.view-finance-form').find('.finance-tab a').on('click', function (e) {
                        e.preventDefault();
                        $(this).tab('show')
                        $('.finance-tab a').removeClass('active');
                        $(this).addClass('active');
                    });
                } else {
                    $.alert({
                        title: 'Error',
                        content: response.msg
                    });
                }
            }
        });
    });
    $('.view-list-finance').find('.btn-add-new').click(function (e) {
        var id = $(this).data('id');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: wpbookingpro_root_url + "wp-json/woobooking_api/1.0/finance/get_finance_by_id",
            data: {
                action: "get_data",
                id: id
            },
            success: function (response) {
                $wooBooking.getDrawer().find('.hy-drawer-content').html(response);
                $wooBooking.getDrawer().drawer('toggle');
                $('.view-finance-form').find('.finance-tab a').on('click', function (e) {
                    e.preventDefault();
                    $(this).tab('show')
                })
            }
        });
    });
    $('.view-list-finance').find('.btn-delete').click(function (e) {
        var id = $(this).data('id');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: wpbookingpro_root_url + "wp-json/woobooking_api/1.0/finance/get_finance_by_id",
            data: {
                action: "get_data",
                id: id
            },
            success: function (response) {
                $wooBooking.getDrawer().find('.hy-drawer-content').html(response);
                $wooBooking.getDrawer().drawer('toggle');
                $('.view-finance-form').find('.finance-tab a').on('click', function (e) {
                    e.preventDefault()
                    $(this).tab('show')
                })
            }
        });
    });
});