"use strict";
(function ($) {
    $.view_list_employee = function (element, options) {
        var defaults = {
            class_name_drawerel: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $class_name_drawerel = plugin.settings.class_name_drawerel;
            $wooBooking.set_class_name_drawerel($class_name_drawerel);
            let employee_id;
            $element.find('.checkmark').click(function (e) {
                let $wrapper_employee_item = $(this).closest('.wrapper-employee-item');
                employee_id = $wrapper_employee_item.data('employee_id');
                let checkBoxes = $wrapper_employee_item.find('.delete-employee');
                checkBoxes.prop("checked", !checkBoxes.prop("checked"));
            })
            $element.find('.btn-add-new').click(function (e) {
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "employee.ajax_get_item"
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "employee.ajax_save");
                            $wooBooking.getDrawer().drawer('toggle');
                            $wooBooking.getDrawer().find('h4.title').html('Add new employee');
                            $('.view-employee-form').find('.employee-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.employee-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        }
                    }
                });
            });
            $element.find('.btn-edit-employee').live('click', function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "employee.get_employee_by_id",
                        id: id
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "employee.ajax_save");
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                            $wooBooking.getDrawer().drawer('toggle');
                            $wooBooking.getDrawer().find('h4.title').html(`Edit employee: ${id}`);
                            $('.view-employee-form').find('.employee-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.employee-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        } else {
                            $.alert({
                                title: 'Error',
                                content: response.msg
                            });
                        }
                    }
                });
            });
            $element.find('.checked-all').click(function (e) {
                $('table.list-employee').find('.checkbox-item').prop('checked', $(this).is(':checked'));
            });
            $('table.list-employee').find('.checkbox-item').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-employee').find('.checkbox-item');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_employee_id = [];
                $element.find('.delete-employee:checked').each(function () {
                    list_delete_employee_id.push($(this).val());
                });
                if (list_delete_employee_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose employee before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this image in gallery ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "employee.ajax_delete",
                                    list_delete_employee_id: list_delete_employee_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            // $wooBooking.call_back_when_save_success = function (data, is_new) {
            //     location.reload(true);
            // }
        }
        plugin.call_back_when_save_success = function (item_employee, is_new) {
            let item_employee_html = `<div class="col-md-4">${plugin.settings.item_employee_html}</div>`;
            let $item_employee_html = $(item_employee_html);
            $item_employee_html.appendTo($element.find('.list-employee.main-table > .row'));
            $item_employee_html.find('email').html(item_employee.email);
        };
        plugin.call_back_when_duplicate_success = function (item_employee, is_new) {
        };
        plugin.call_back_when_delete_success = function (item_employee, is_new) {
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_employee = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_employee')) {
                var plugin = new $.view_list_employee(this, options);
                $(this).data('view_list_employee', plugin);
            }
        });
    }
})(jQuery);
