const path = require('path')
const webpack = require('webpack')
const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin
const VueLoaderPlugin = require('vue-loader/lib/plugin')
const TerserPlugin = require('terser-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin')
const { CleanWebpackPlugin } = require('clean-webpack-plugin')
const VuetifyLoaderPlugin = require('vuetify-loader/lib/plugin')

const isDev = () => {
	return (process.env.NODE_ENV === 'development')
}

module.exports = {
	entry: './src/main.js',
	output: {
		path: path.resolve(__dirname, './assets/admin/dashboard'),
		publicPath: path.resolve(__dirname, './assets/admin/dashboard'),
		filename: 'build.js'
	},
	module: {
		rules: [
			{
				test: /\.vue$/,
				loader: 'vue-loader',
			},
			{
				test: /\.(sa|sc|c)ss$/,
				use: [
					isDev() ? 'vue-style-loader': MiniCssExtractPlugin.loader,
					'css-loader',
					'sass-loader',
				],
			},
			{
				test: /\.js$/,
				loader: 'babel-loader',
				exclude: /node_modules/
			},
			{
				test: /\.(png|jpg|gif|svg)$/,
				loader: 'file-loader',
				options: {
				name: '[name].[ext]?[hash]'
				}
			},
			{
				test: /\.(png|woff|woff2|eot|ttf|svg)$/,
				loader: 'url-loader'
			}
		]
	},
	resolve: {
		extensions: [ '.js', '.vue' ],
		alias: {
		'vue$': 'vue/dist/vue.esm.js'
		}
	},
	devServer: {
		historyApiFallback: true,
		noInfo: true
	},
	performance: {
		hints: false
	},
	plugins: [
		new BundleAnalyzerPlugin(),
		new VueLoaderPlugin(),
		new MiniCssExtractPlugin(),
		new CleanWebpackPlugin(),
		new VuetifyLoaderPlugin()
	],
	devtool: '#eval-source-map'
}

if (process.env.NODE_ENV === 'production') {
	module.exports.mode = 'production'
	module.exports.devtool = '#source-map'
	module.exports.optimization = {
		minimizer: [new TerserPlugin()],
	}
	// http://vue-loader.vuejs.org/en/workflow/production.html
	module.exports.plugins = (module.exports.plugins || []).concat([
		new webpack.LoaderOptionsPlugin({
			minimize: true
		}),
	])
	} else {
	module.exports.mode = 'development'  
}