<?php 
class NB_sale_products_widget extends WP_Widget {
	
	public function __construct() {
	
		// remove sale products from the page when this widget is used
		add_action( 'wp', array( $this, 'remove_sale_products' ) );
		
		// adjust the display of sale products when used in the widget
		/*
		add_action( 'wp_print_footer_scripts', array( $this, 'modify_sale_products_styles' ) );*/
		add_filter( 'woocommerce_output_sale_products_args', array( $this, 'change_sale_product_columns' ) );
		
		
		
		// instantiate the widget
		parent::__construct(
			'NB_sale_products_widget', 
			__( 'NB sale Products', 'aidoo-elements' ),
			array( 'description' => __( 'Displays sale products when on product pages', 'aidoo-elements' ),
			'panels_groups' => array('netbaseteam') ) 
		); 		
		
	}	
	/**
	 * Render the widget
	 *
	 * @since 1.0
	 * @see WP_Widget::widget()
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
	
		// Only show this if we're looking at a product page
		global $product;

		if ( ! $product ) {
			return;
		}
		if ( ! is_singular( 'product' ) ) {
			return;
		}
		
		// get the widget configuration
		$title = $instance['title'];
		
		echo $args['before_widget'];
		
		if ( $title ) {
			echo $args['before_title'] . wp_kses_post( $title ) . $args['after_title'];
		}
		$id = get_the_ID();	
		$terms = wp_get_post_terms( $id, 'product_cat' );
		$meta_query   = WC()->query->get_meta_query();
		// Show the product's sale items
		

		$sale_posts = array(
			'orderby' => 'rand',
			'post_status'           => 'publish',
			'ignore_sticky_posts'   => 1,
			'posts_per_page'        => '3',
			'post_type' => 'product',
			'fields' => 'ids',
			'meta_query' => array(
                'relation' => 'OR',
                array( // Simple products type
                    'key'           => '_sale_price',
                    'value'         => 0,
                    'compare'       => '>',
                    'type'          => 'numeric'
                ),
                array( // Variable products type
                    'key'           => '_min_variation_sale_price',
                    'value'         => 0,
                    'compare'       => '>',
                    'type'          => 'numeric'
                )
            ),
			'tax_query' => array(
                'relation' => 'OR',
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'id',
                    'terms' => $terms[0]->name,
                )
			)
		);
		$loop = new WP_Query( $sale_posts );
		while ( $loop->have_posts() ) : $loop->the_post(); 

		$product = new WC_Product(get_the_ID());
			?>
			
			<div class="sale-product">   
				<a href="<?php the_permalink(); ?>"> 
				<?php 
					if ( has_post_thumbnail( $loop->ID ) ) 
						echo get_the_post_thumbnail( $loop->ID, 'shop_catalog' ); 
					else 
						echo '<img src="' . woocommerce_placeholder_img_src() . '" alt="Placeholder" width="65px" height="115px" />'; 
				?>
				</a>
				<div class="sale_content">
					<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3> 
					<div class="price">
						<?php if( $product->is_on_sale() ) { ?>
						<div class="sale">
							<?php echo get_woocommerce_currency_symbol(); ?>
							<span><?php echo $product->get_sale_price();?> </span>	
						</div>
						<?php } ?>
						<?php if($product->get_regular_price() != null){ ?>
						<div class="regular">
							<?php echo get_woocommerce_currency_symbol(); ?>
							<span><?php echo $product->get_regular_price();?> </span>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>

	<?php 
	endwhile;
	
	echo $args['after_widget'];
	}
	

	/**
	 * Update the widget title
	 *
	 * @since 1.0
	 * @see WP_Widget::update()
	 * @param array $new_instance new widget settings
	 * @param array $old_instance old widget settings
	 * @return array updated widget settings
	 */
	public function update( $new_instance, $old_instance ) {
		$instance['title'] = strip_tags( $new_instance['title'] );
		return $instance;
	}
	

	/**
	 * Render the admin form for the widget
	 *
	 * @since 1.0.0
	 * @see WP_Widget::form()
	 * @param array $instance the widget settings
	 * @return string|void
	 */
	public function form( $instance ) {
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'woocommerce-sale-products-widget' ) ?>:</label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( isset( $instance['title'] ) ? $instance['title'] : '' ); ?>" />
		</p>
		<?php
	}


	/** 
	 * Removes the sale products from their current location on the product page
	 *
	 * @since 1.0.0
	 */
	public function remove_sale_products() {
	
		if ( is_singular( 'product' ) ) {
			remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_sale_products', 20 );
		}
	}
	
	/**
	 * Changes the number of sale products columns when displayed in the widget
	 *
	 * @since 1.0
	 * @param array $args arguments for sale display
	 * @return array the updated arguments
	 */
	public function change_sale_product_columns( $args ) {
	
		if ( is_singular( 'product' ) ) {
			$args['posts_per_page'] = 4; 
			$args['columns'] = 1; 			
		}
		return $args;
	}
	

	
	/**
	 * Add some specific CSS for the widget
	 *
	 * @since 1.0.0
	 */
	 /*
	public function modify_sale_products_styles() {
	
		if ( is_singular( 'product' ) && is_active_widget( false, false, $this->id_base ) ) {
		
			echo '<style>
				.woocommerce .widget_wc_sale_products ul.products li.product,
				.woocommerce-page .widget_wc_sale_products ul.products li.product {
					width: 48%;
					margin-top: 1em;
				}
			</style>';
		}
	}*/
	
} // end \wpnetbase_sale_products_widget class


/**
 * Registers the new widget to add it to the available widgets
 * 
 * @since 1.0.0
 */
function NB_sale_products_register_widget() {
	register_widget( 'NB_sale_products_widget' );
}
add_action( 'widgets_init', 'NB_sale_products_register_widget' );