<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Instagram extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'aidoo_instagram', array( $this, 'shortcode_element_instagram' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
       
        vc_map(array(
            'name'          => esc_html__('Instagram', 'aidoo-elements'),
            'base'          => 'aidoo_instagram',
            'icon'          => 'icon-wpb-wp',
            'category'      => esc_html__('Aidoo', 'aidoo-elements'),
            'description'   => esc_html__('Display Instagram photos.', 'aidoo-elements'),
            'params'        => array(

                array(
                    'param_name' => 'username',
                    'heading'    => esc_html__( 'Username', 'aidoo-elements' ),
                    'type'       => 'textfield',
                ),

                array(
                    'param_name' => 'number',
                    'heading'    => esc_html__( 'Number of photos', 'aidoo-elements' ),
                    'type'       => 'textfield',
                ),

                array(
                    'param_name' => 'desktop',
                    'heading'    => esc_html__( 'Desktop Column', 'aidoo-elements' ),
                    'type'       => 'textfield',
                ),

                array(
                    'param_name' => 'tablet',
                    'heading'    => esc_html__( 'Tablet Column', 'aidoo-elements' ),
                    'type'       => 'textfield',
                ),

                array(
                    'param_name' => 'mobile',
                    'heading'    => esc_html__( 'Mobile Column', 'aidoo-elements' ),
                    'type'       => 'textfield',
                ),

                array(
                    'param_name' => 'size',
                    'heading'    => esc_html__( 'Photo size', 'aidoo-elements' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Large', 'aidoo-elements' ) => 'large',
                        __( 'Thumbnail', 'aidoo-elements' ) => 'thumbnail',
                        __( 'Small', 'aidoo-elements' ) => 'small',
                        __( 'Original', 'aidoo-elements' ) => 'original',
                    ),
                ),
                array(
                    'param_name' => 'target',
                    'heading'    => esc_html__( 'target', 'aidoo-elements' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'New window (_blank)', 'aidoo-elements' ) => '_blank',
                        __( 'Current window (_self)', 'aidoo-elements' ) => '_self',
                    ),

                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_element_instagram($atts, $content = null)
    {
        $column = $stylecss = '';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    /*'title'          => '',*/
                    'username' => '',
                    'number' => '',
                    'size' => '',
                    'target' =>'',
                    'desktop' => '6',
                    'tablet' => '3',
                    'mobile' => '1'
                ),
                $atts
            )
        );

        $stylecss .='padding: 0px;' ;
        if ( $stylecss ) {
            $stylecss = ' style="' . $stylecss . '"';
        }
        if ( $desktop ) {
            $column .= '"desktop":"'.$desktop.'", ';
        }
        if ( $tablet ) {
            $column .= '"tablet":"'.$tablet.'", ';
        }
        if ( $mobile ) {
            $column .= '"mobile":"'.$mobile.'"';
        }

        ob_start();
        if ( $username != '' ) {
            $limit = empty( $number ) ? 9 : $number;
            $target = empty( $target ) ? '_self' : $target;
            $size = empty( $size ) ? 'large' : $size;
            $media_array = self::scrape_instagram( $username );

            if ( is_wp_error( $media_array ) ) {

                echo wp_kses_post( $media_array->get_error_message() );

            } else {

                // filter for images only?
                if ( $images_only = apply_filters( 'print_images_only', FALSE ) ) {
                    $media_array = array_filter( $media_array, array( $this, 'images_only' ) );
                }
                // slice list down to required limit
                $media_array = array_slice( $media_array, 0, $limit );
                // filters for custom classes
                $ulclass = apply_filters( 'print_list_class', 'instagram-widget-img instagram-size-' . $size );

                ?><div class="<?php echo esc_attr( $ulclass ); ?>">
                <div class="instagram swiper-container" data-responsive='{<?php echo $column;?>}'>
                    <div class="swiper-wrapper">
                <?php foreach ( $media_array as $item ) {

                    echo '<div class="instagram-pics swiper-slide" '.$stylecss.'>
                    <a href="'. esc_url( $item['link'] ) .'" target="'. esc_attr( $target ) .'" >
                    <img src="' . esc_url( $item[$size] ) . '"  alt="' . esc_attr( $item['description'] ) . '" title="' . esc_attr( $item['description'] ) . '"  />
                    <div class="wrap-icon">
                    <span class="icon-heart3">'.$item['likes'].'</span>
                    <span class="icon-speech-bubble">'.$item['comments'].'</span>
                    </div>
                    </a>
                    </div>';
                }
                ?>
                    </div>
                </div>
                    <!-- Add Arrows -->
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                <?php
            }
        }

        return '<div  class="nb-fw" >' . ob_get_clean() . '</div>';

    }

    public function scrape_instagram( $username ) {

        $username = trim( strtolower( $username ) );

        switch ( substr( $username, 0, 1 ) ) {
            case '#':
                $url              = 'https://instagram.com/explore/tags/' . str_replace( '#', '', $username );
                $transient_prefix = 'h';
                break;

            default:
                $url              = 'https://instagram.com/' . str_replace( '@', '', $username );
                $transient_prefix = 'u';
                break;
        }

        if ( false === ( $instagram = get_transient( 'insta-a10-' . $transient_prefix . '-' . sanitize_title_with_dashes( $username ) ) ) ) {

            $remote = wp_remote_get( $url );

            if ( is_wp_error( $remote ) ) {
                return new WP_Error( 'site_down', esc_html__( 'Unable to communicate with Instagram.', 'wp-instagram-widget' ) );
            }

            if ( 200 !== wp_remote_retrieve_response_code( $remote ) ) {
                return new WP_Error( 'invalid_response', esc_html__( 'Instagram did not return a 200.', 'wp-instagram-widget' ) );
            }

            $shards      = explode( 'window._sharedData = ', $remote['body'] );
            $insta_json  = explode( ';</script>', $shards[1] );
            $insta_array = json_decode( $insta_json[0], true );

            if ( ! $insta_array ) {
                return new WP_Error( 'bad_json', esc_html__( 'Instagram has returned invalid data.', 'wp-instagram-widget' ) );
            }

            if ( isset( $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'] ) ) {
                $images = $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'];
            } elseif ( isset( $insta_array['entry_data']['TagPage'][0]['graphql']['hashtag']['edge_hashtag_to_media']['edges'] ) ) {
                $images = $insta_array['entry_data']['TagPage'][0]['graphql']['hashtag']['edge_hashtag_to_media']['edges'];
            } else {
                return new WP_Error( 'bad_json_2', esc_html__( 'Instagram has returned invalid data.', 'wp-instagram-widget' ) );
            }

            if ( ! is_array( $images ) ) {
                return new WP_Error( 'bad_array', esc_html__( 'Instagram has returned invalid data.', 'wp-instagram-widget' ) );
            }

            $instagram = array();

            foreach ( $images as $image ) {
                if ( true === $image['node']['is_video'] ) {
                    $type = 'video';
                } else {
                    $type = 'image';
                }

                $caption = __( 'Instagram Image', 'wp-instagram-widget' );
                if ( ! empty( $image['node']['edge_media_to_caption']['edges'][0]['node']['text'] ) ) {
                    $caption = wp_kses( $image['node']['edge_media_to_caption']['edges'][0]['node']['text'], array() );
                }

                $instagram[] = array(
                    'description' => $caption,
                    'link'        => trailingslashit( '//instagram.com/p/' . $image['node']['shortcode'] ),
                    'time'        => $image['node']['taken_at_timestamp'],
                    'comments'    => $image['node']['edge_media_to_comment']['count'],
                    'likes'       => $image['node']['edge_liked_by']['count'],
                    'thumbnail'   => preg_replace( '/^https?\:/i', '', $image['node']['thumbnail_resources'][0]['src'] ),
                    'small'       => preg_replace( '/^https?\:/i', '', $image['node']['thumbnail_resources'][2]['src'] ),
                    'large'       => preg_replace( '/^https?\:/i', '', $image['node']['thumbnail_resources'][4]['src'] ),
                    'original'    => preg_replace( '/^https?\:/i', '', $image['node']['display_url'] ),
                    'type'        => $type,
                );
            } // End foreach().

            // do not set an empty transient - should help catch private or empty accounts.
            if ( ! empty( $instagram ) ) {
                $instagram = base64_encode( serialize( $instagram ) );
                set_transient( 'insta-a10-' . $transient_prefix . '-' . sanitize_title_with_dashes( $username ), $instagram, apply_filters( 'null_instagram_cache_time', 10 ) );
            }
        }

        if ( ! empty( $instagram ) ) {

            return unserialize( base64_decode( $instagram ) );

        } else {

            return new WP_Error( 'no_images', esc_html__( 'Instagram did not return any images.', 'wp-instagram-widget' ) );

        }
    }

    public function images_only( $media_item ) {

        if ( 'image' === $media_item['type'] ) {
            return true;
        }

        return false;
    }

}
new NB_Element_Instagram();
}