<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
  exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
  class NB_Element_Product_Online_Design extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
      add_action( 'init', array( $this, 'map' ), 12 );
      add_shortcode( 'aidoo_product_online_design', array( $this, 'shortcode_product_online_design' ) );
    }


    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
      // Stop all if VC is not enabled
		if ( !defined( 'WPB_VC_VERSION' ) ) {
			return;
		}
      
		vc_map(array(
			'name' => esc_html__('Product Online Design', 'aidoo-elements'),
			'base' => 'aidoo_product_online_design',
			'category' => esc_html__('Aidoo', 'aidoo-elements'),
			'description' => esc_html__('Display product online with button design.', 'aidoo-elements'),
			'icon' => 'icon-wpb-wp',
			'params' => array(
			array(
				'type' => 'textfield',
				'admin_label' => true,
				'heading' => esc_html__('Limit number product', 'aidoo-elements'),
				'param_name' => 'num_pro_design',
				'value' => '10',
			),

			array(
				'type' => 'textfield',
				'admin_label' => true,
				'heading' => esc_html__('Filter product by ID', 'aidoo-elements'),
				'param_name' => 'post_id',
				'value' => '',
			),

			array(
				'type' => 'textfield',
				'admin_label' => true,
				'heading' => esc_html__('Text button', 'aidoo-elements'),
				'param_name' => 'text_button',
				'value' => 'DESIGN NOW',
			),

			array(
				'param_name'  => 'fontsize_button',
				'heading'     => esc_html__( 'Font size button', 'aidoo-elements' ),
				'type'        => 'dropdown',
				'value'       => array(
				__( '14px', 'aidoo-elements' )  => '14',
				__( '16px', 'aidoo-elements' ) => '16',
				),
				'std'         => '14',
			),

			array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => __( "Background color button", "aidoo-elements" ),
				"param_name" => "color_button_design",
				"value" => '#4285f4',
			),

			array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => __( "Color text button", "aidoo-elements" ),
				"param_name" => "color_text_button_design",
				"value" => '#fff',
			),

			array(
				'type' => 'textfield',
				'admin_label' => true,
				'heading' => esc_html__('Round button', 'aidoo-elements'),
				'param_name' => 'round_button_design',
				'value' => '',
				"description" => __( "Border radius button ( Example: 5px )", "aidoo-elements" ),
			),

			array(
				'type' => 'textfield',
				'admin_label' => true,
				'heading' => esc_html__('Margin bottom between products', 'aidoo-elements'),
				'param_name' => 'margin_pro_design',
				'value' => '',
				"description" => __( "Margin bottom ( Example: 15px or 15% )", "aidoo-elements" ),
			),

			array(
				"type" => "dropdown",
				"heading" => __("Order by", "aidoo-elements"),
				"param_name" => "direction",
				"value" => array(__("Ascendant", "aidoo-elements") => "ASC" ,__("Descendant", "aidoo-elements") => "DESC"), 
				"description" => __("", "aidoo-elements")
			),

			array(
				'param_name'  => 'columns',
				'heading'     => esc_html__( 'Number of columns displayed', 'aidoo-elements' ),
				'type'        => 'dropdown',
				'value'       => array(
				__( '1 column', 'aidoo-elements' )  => '1',
				__( '2 columns', 'aidoo-elements' ) => '2',
				__( '3 columns', 'aidoo-elements' ) => '3',
				__( '4 columns', 'aidoo-elements' ) => '4',
				__( '5 columns', 'aidoo-elements' ) => '5',
				__( '6 columns', 'aidoo-elements' ) => '6',
				),
				'std'         => '4',
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),

			array(
				'type' => 'checkbox',
				'admin_label' => true,
				'heading' => esc_html__('Enable Title', 'aidoo-elements'),
				'param_name' => 'enable_title',
				'std' => true,
				"value" => array('Show title product' => true )
			),

			array(
				'type' => 'checkbox',
				'admin_label' => true,
				'heading' => esc_html__('Enable Title Bold', 'aidoo-elements'),
				'param_name' => 'title_bold',
				'std' => true,
				"value" => array('Enable Title Bold' => true )
			),

			array(
				'type' => 'textfield',
				'admin_label' => true,
				'heading' => esc_html__('Font size title product', 'aidoo-elements'),
				'param_name' => 'font_size_title_pro_design',
				'value' => '18',
			),
		)
	));
}

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
	public function shortcode_product_online_design($atts, $content = null)
	{
	global $post;

	$html = $attr_parent = $class_columns = $button_style = $title_style = '';
	extract(
		shortcode_atts(
			array(
			'num_pro_design' => 10,
			'margin_pro_design' => '0px',
			'round_button_design' => '0px',
			'margin_top_pro_design' => '0px',
			'color_button_design' => '#4285f4',
			'color_text_button_design' => '#fff',
			'enable_title' => true,
			'text_button' => 'DESIGN NOW',
			'columns' => 4,
			'fontsize_button' => 14,
			'font_size_title_pro_design' => '18',
			'direction' => 'ASC',
			'title_bold' => true,
			'post_id' => ''
			),
			$atts
		)
    );

	switch ($columns) {
		case '1':
		$class_columns= 'col-md-12';
		break;
		case '2':
		$class_columns= 'col-md-6';
		break;
		case '3':
		$class_columns= 'col-md-4';
		break;
		case '4':
		$class_columns= 'col-md-3';
		break;
		case '5':
		$class_columns= 'col-md-2-5';
		break;
		case '6':
		$class_columns= 'col-md-2';
		break;
		default:
		$class_columns ='col-md-4';
	}
	
	if($color_button_design){
		$button_style = 'background-color:'.$color_button_design.';';
	}
	if($color_text_button_design){
		$button_style .= 'color:'.$color_text_button_design.';';
	}
	if($round_button_design){
		$button_style .= 'border-radius:'.$round_button_design.';';
	}
	if($fontsize_button){
		$button_style .= 'font-size:'.$fontsize_button.'px;';
	}

	if($font_size_title_pro_design){
		$title_style = 'font-size:'.$font_size_title_pro_design.'px;';
	}
	if($title_bold){
		$title_style .= 'font-weight:bold';
	}
	

    $args = array(
		'p' => $post_id,
		'posts_per_page'    => $num_pro_design,
		'post_type' => 'product',
		'order' => $direction,
		'meta_query' => array(
			array(
			'key'       => '_nbdesigner_enable',
			'value'     => true
			),
      ),
    );

	// The Query
	$the_query = new WP_Query( $args );
	?>

	<div class="product-online-desginer">
		<div class="row">
			<div class="col-xs-12 col-md-12">
				<ul style="margin-top:<?php echo $margin_top_pro_design; ?>">
					<?php if ( $the_query->have_posts() ) {
						while ( $the_query->have_posts() ) {
						$the_query->the_post();?>
							<li class="<?php echo $class_columns; ?>" style="margin-bottom:<?php echo $margin_pro_design; ?>">
								<div class="pr">
								<?php 
								$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'woocommerce_thumbnail' );
								if ( has_post_thumbnail() ) { ?>
								<img src="<?php echo esc_url($large_image_url[0]); ?>" alt="<?php echo esc_attr($post->post_title); ?>"/>
								<?php } 
								$url = '';
								if ( is_plugin_active('web-to-print-online-designer/nbdesigner.php') ) {
									$url =  add_query_arg(array(
										'product_id'    =>  $post->ID
									),  getUrlPageNBD('create'));
								};
								?>
									<div class="product-online-designer-detail">
										<div class="links-wrap">
											<a href="<?php echo $url; ?>">
												<h6 style="<?php echo $button_style; ?>"><?php echo $text_button; ?></h6>
											</a>
										</div>
									</div>
								</div>
								<?php if($enable_title) { ?>
									<a href="<?php echo $url; ?>">
										<h4 style="<?php echo $title_style; ?>"><?php echo $post->post_title ?></h4>
									</a>
								<?php } ?>
							</li>
						<?php
						wp_reset_postdata();
						}
						}
					?>
				</ul>
			</div>
		</div>
	</div>

	<?php
  }

}
new NB_Element_Product_Online_Design(); 
}