<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Our_Team extends WPBakeryShortCode {
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'aidoo_our_team', array( $this, 'shortcode_banner' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'          => esc_html__( 'Our Team', 'aidoo-elements' ),
            'base'          => 'aidoo_our_team',
            'icon'          => 'icon-wpb-wp',
            'category'      => __('Aidoo', 'aidoo-elements'),
            'description'   => esc_html__( 'Display Our Team', 'aidoo-elements' ),
            'params'        => array(
                //Title
                
                array(
                    'heading'    => esc_html__( 'Our Team content', 'nb-fw' ),
                    'type'       => 'param_group',
                    'param_name' => 'our_team_content',
                    'params'     => array(
                        array(
                            'heading'     => __( 'Image', 'aidoo-elements' ),
                            'param_name'  => 'avatar',
                            'type'        => 'attach_image',
                        ),
                        array(
                            'heading'    => __( 'Name ', 'aidoo-elements' ),
                            'param_name' => 'txt_caption',
                            'type'       => 'textfield'
                        ), 
                        array(
                            'heading'    => __( 'Occupations', 'aidoo-elements' ),
                            'param_name' => 'txt_occupations',
                            'type'       => 'textfield'
                        ), 
                        array(
                            'heading'    => __( 'Description', 'aidoo-elements' ),
                            'param_name' => 'txt_des',
                            'type'       => 'textfield'
                        )
                    )
                ),
                array(
                    'param_name'  => 'tag_name',
                    'heading'     => esc_html__( 'Tag name', 'nb-fw' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( 'H1', 'nb-fw' )  => 'h1',
                        __( 'H2', 'nb-fw' ) => 'h2',
                        __( 'H3', 'nb-fw' ) => 'h3',
                        __( 'H4', 'nb-fw' ) => 'h4',
                        __( 'H5', 'nb-fw' ) => 'h5',
                        __( 'H6', 'nb-fw' ) => 'h6',
                    ),                     
                    'std'         => 'h4',
                ),
                array(
                    'param_name' => 'facebook',
                    'heading'    => esc_html__( 'Link Facebook', 'nb-fw' ),
                    'type'       => 'textfield',
                ),
                array(
                    'param_name' => 'twitter',
                    'heading'    => esc_html__( 'Link Twitter', 'nb-fw' ),
                    'type'       => 'textfield',
                ),
                array(
                    'param_name' => 'google_plus',
                    'heading'    => esc_html__( 'Link Google plus', 'nb-fw' ),
                    'type'       => 'textfield',
                ),
                array(
                    'param_name' => 'linkedin',
                    'heading'    => esc_html__( 'Linkedin', 'nb-fw' ),
                    'type'       => 'textfield',
                ),
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_banner($atts, $content = null)
    {
        $html = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'our_team_content' => '',
                    'avatar' => '',
                    'txt_caption' => '',
                    'txt_occupations' => '',
                    'txt_des' => '',
                    'tag_name' => 'h4',
                    'facebook' => '',
                    'twitter' => '',
                    'google_plus' => '',
                    'linkedin' => '',
                ),
                $atts
            )
        );
        
        $values = ( array ) vc_param_group_parse_atts( $our_team_content );

        $html = '<div id="vc-our-team" class="row">';
        
        foreach ( $values as $value ) {
            $image_link = '';
            if ( !empty( $value[ 'avatar' ] ) ) {
                $image        = wpb_getImageBySize( array( 'attach_id' => $value[ 'avatar' ] ) );
                $image_link   = $image[ 'p_img_large' ][ 0 ];
            }
            
            $html.='<div class="col-md-3">';
            $html.='<div class="our-content">';
                if(!empty($image_link)){
                    $html.='<div class="our-thumbnail">';

                    $html.='<img src="'.$image_link.'"/>';
                    
                    if ( ! empty( $facebook ) || ! empty( $twitter ) || ! empty( $google_plus ) ) {
                                
                        $html .='<div class="ourteam-social-share">';
                            if ( ! empty( $facebook ) ) {
                                $html .= '<a href="' . esc_html( $facebook ) . '"><i class="icon-facebook"></i> </a>';
                            }
                            if ( ! empty( $twitter ) ) {
                                $html .= '<a href="' . esc_html( $twitter ) . '"><i class="icon-twitter"></i></a>';
                            }
                            if ( ! empty( $google_plus ) ) {
                                $html .= '<a href="' . esc_html( $google_plus ) . '"><i class="icon-pinterest2"></i></a>';
                            }
                            if ( ! empty( $linkedin ) ) {
                                $html .= '<a href="' . esc_html( $linkedin ) . '"><i class="icon-linkedin"></i></a>';
                            }
                        $html .='</div>';

                    }
                    $html.='</div>';
                }
                $html.='<div class="our-info">';
                if(!empty($value['txt_caption'])){
                    $html.='<'.$tag_name.' class="caption">'.esc_html( $value['txt_caption']).'</'.$tag_name.'>';
                }

                if(!empty($value['txt_occupations'])){
                    $html.='<div class="occupations">'.esc_html( $value['txt_occupations']).'</div>';
                }

                if(!empty($value['txt_des'])){
                    $html.='<div class="description">'.esc_html($value['txt_des']).'</div>';
                }
                $html.='</div>';
            $html.='</div>';
            $html.='</div>';
        }

        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_our_team', force_balance_tags($html));
    }
     
} // End Element Class
 
// Element Class Init
new NB_Element_Our_Team(); 
}
