<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
if(is_plugin_active('netbase_solutions/netbase_solutions.php')){
// Element Class 
class NB_Element_Brands_List extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'aidoo_brand_listing', array( $this, 'shortcode_brands_list' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }        
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'List Brands', 'aidoo-elements' ),
            'base'        => 'aidoo_brand_listing',
            'icon' => 'icon-wpb-wp',
            'category' => __('Aidoo', 'aidoo-elements'),
            'description' => esc_html__( 'Display List Brands.', 'aidoo-elements' ),
            'params'      => array(
                array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Show Per page', 'aidoo-elements' ),
                        'value' => 12,
                        'save_always' => true,
                        'admin_label'   => true,
                        'param_name' => 'per_page',
                        'description' => esc_html__( 'How many brand to show on the page', 'aidoo-elements' ),
                ),

                array(
                    'param_name'  => 'items_per_slide',
                    'heading'     => esc_html__( 'Items per slide', 'aidoo-elements' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( '1', 'aidoo-elements' )  => '1',
                        __( '2', 'aidoo-elements' ) => '2',
                        __( '3', 'aidoo-elements' ) => '3',
                        __( '4', 'aidoo-elements' ) => '4',
                        __( '5', 'aidoo-elements' ) => '5',
                        __( '6', 'aidoo-elements' ) => '6',
                        __( '7', 'aidoo-elements' ) => '7',
                        __( '8', 'aidoo-elements' ) => '8',
                    ),
                    'std'         => '1',
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'type' => 'dropdown',
                        'heading' => __('Item Align', 'aidoo-elements'),
                        'param_name' => 'item_align',                        
                        'value' => array(
                                'Center' => 'text-center',
                                'Right' => 'text-right',
                                'Left' => 'text-left',
                                
                        ),
                        'std' => 'text-center',
                        'save_always' => true,                            
                ), 

                array(
                        'param_name' => 'loop',
                        'heading'    => esc_html__( 'Enable Loop', 'aidoo-elements' ),
                        'type'       => 'checkbox',                        
                ),

                array(
                    'param_name'  => 'itemstablet',
                    'heading'     => esc_html__( 'Number of columns displayed Tablet', 'aidoo-elements' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( '1', 'aidoo-elements' )  => '1',
                        __( '2', 'aidoo-elements' ) => '2',
                        __( '3', 'aidoo-elements' ) => '3',
                        __( '4', 'aidoo-elements' ) => '4',
                        __( '5', 'aidoo-elements' ) => '5',
                        __( '6', 'aidoo-elements' ) => '6',
                        __( '7', 'aidoo-elements' ) => '7',
                        __( '8', 'aidoo-elements' ) => '8',
                    ),               
                    'std'         => 3,   
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                    'param_name'  => 'itemsmobile',
                    'heading'     => esc_html__( 'Number of columns displayed Mobile', 'aidoo-elements' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( '1', 'aidoo-elements' )  => '1',
                        __( '2', 'aidoo-elements' ) => '2',
                        __( '3', 'aidoo-elements' ) => '3',
                        __( '4', 'aidoo-elements' ) => '4',
                        __( '5', 'aidoo-elements' ) => '5',
                        __( '6', 'aidoo-elements' ) => '6',
                        __( '7', 'aidoo-elements' ) => '7',
                        __( '8', 'aidoo-elements' ) => '8',
                    ),                
                    'std'         => 2,   
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Border image brand', 'aidoo-elements'),
                    'param_name' => 'border_img',
                    'std' => true,                    
                ),

                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'aidoo-elements' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'aidoo-elements' ),
                ),
               
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_brands_list($atts, $content = null)
    {
        global $woocommerce;
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'         => '',                    
                    'per_page'  => '',
                    'item_align' => 'text-center',
                    'loop'         => '',  
                    'items_per_slide'=> '1',            
                    'itemstablet' => '3', 
                    'itemsmobile' => '2',
                    'border_img' => true,
                    'css' => '',
                ),
                $atts
            )
        );

        $id = uniqid('netbase_custom_css_');
        $classes = array();
        $css_class = '';

        $classesc  = $attr = array();

        if ( ! empty( $items_per_slide ) ) {
            $attr[] = '"items": "' . ( int ) $items_per_slide . '"';
        }
        if ( ! empty( $itemstablet ) ) {
            $attr[] = '"tablet": "' . ( int ) $itemstablet . '"';
        }
        if ( ! empty( $itemsmobile ) ) {
            $attr[] = '"mobile": "' . ( int ) $itemsmobile . '"';
        }
        if($loop){
            $attr[] = '"loop": "true"';
        }
        if ( ! empty( $attr ) ) {
            $data_perpage = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
        }            

        if ( ! empty( $border_img ) ) {
            $classesc[] = 'border';
        }
        if ( ! empty( $item_align ) ) {
            $classesc[] = $item_align;
        }

        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'aidoo_brand_listing', $atts ); 

        $per_page = absint($per_page);

        $terms = get_terms( array(
                'taxonomy' => 'product_brand',
                'number' => $per_page,
                'hide_empty' => false,
            ) );
            
        ob_start();

        if($terms){
            ?>
            <div class="swiper-wrapper">
            <?php
            foreach ($terms as $key => $term) {

                $brands_thumbnail = get_term_meta( $term->term_id, 'brands_thumbnail', true );
                $brands_thumbnail = wp_get_attachment_image_src($brands_thumbnail);

                $brands_target = get_term_meta( $term->term_id, 'brands_target', true );
                $brands_type = get_term_meta( $term->term_id, 'brands_type', true );
                $brands_link  = get_term_link($term, 'product_brand');
                if($brands_type == 'url'){
                    $brands_link = get_term_meta( $term->term_id, 'brands_url', true );
                }               
                ?>
                
                <div class="swiper-slide">
                    <div class="b-thumb">
                        <a href="<?php echo $brands_link;?>" target="<?php echo $brands_target;?>">
                            <img src="<?php echo $brands_thumbnail[0];?>" class="img1" alt="<?php echo $term->name;?>">
                        </a>
                    </div>
                </div>
                <?php
            }
        }                   

        $html .= '<div id="' . esc_attr($id) . '" class="brands-list '. esc_attr( implode( ' ', $classesc ) ) .' '.esc_attr( $css_class ).'"  '.$data_perpage.'>' . ob_get_clean() . '</div>';
        
        // End HTML code.
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_brands_list', force_balance_tags($html));
    } 
} // End Element Class

// Element Class Init
new NB_Element_Brands_List(); 
}
}
