<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Blog
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Blog extends WPBakeryShortCode {
	function __construct() {
        add_action( 'init', array( $this, 'netbase_vc_map' ), 12 );
        add_shortcode( 'aidoo_posts', array( $this, 'aidoo_posts_render' ) );
    }
     
    // Element Mapping
	public function netbase_vc_map() {
		if ( !defined( 'WPB_VC_VERSION' ) ) {
	        return;
		}
		$post_categories_dropdown = array();
		$post_categories_dropdown[] = array(
			'label' => __('Select category', 'aidoo-elements'),
			'value' => '',
		);
		$post_categories_values = $this->getCategories();
		
		$post_categories_dropdown = array_merge($post_categories_dropdown, $post_categories_values);

		$order_posts = array(
			'',
			__('Date', 'aidoo-elements') => 'date',
			__('ID', 'aidoo-elements') => 'ID',
			__('Author', 'aidoo-elements') => 'author',
			__('Title', 'aidoo-elements') => 'title',
			__('Name', 'aidoo-elements') => 'name',
			__('Modified', 'aidoo-elements') => 'modified',
			__('Parent', 'aidoo-elements') => 'parent',
			__('Random', 'aidoo-elements') => 'rand',
			__('Comment count', 'aidoo-elements') => 'comment_count',
			__('Menu order', 'aidoo-elements') => 'menu_order',
		);
		$order_way_values = array(
			'',
			__('Descending', 'aidoo-elements') => 'DESC',
			__('Ascending', 'aidoo-elements') => 'ASC',
		);		
		vc_map(array(
			"name" => __("Blog"),
			"base" => "aidoo_posts",
			'icon' => 'icon-wpb-wp',
			"category" => __('Aidoo', 'aidoo-elements'),
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => __('Style', 'aidoo-elements'),
					'param_name' => 'style',
					'value' => array(
						__('Default', 'aidoo-elements') => '',
						__('Post Masonry', 'aidoo-elements') => 'wppostmasonry'
					),
					'save_always' => true,
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Layout', 'aidoo-elements'),
					'param_name' => 'layout',
					'value' => array(
						__('Image Top', 'aidoo-elements') => 'wp-img-top',
						__('Image Left', 'aidoo-elements') => 'wp-img-left',
						__('Content Absolute', 'aidoo-elements') => 'wp-content-absolute',
					),
					'std' => 'wp-img-top',
					'save_always' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Per page', 'aidoo-elements'),
					'value' => 12,
					'save_always' => true,
					'param_name' => 'per_page',
					'description' => __('The "per_page" shortcode determines how many posts to show on the page', 'aidoo-elements'),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Large Desktops', 'aidoo-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '4',
					'param_name' => 'columns-xl',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Desktops', 'aidoo-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '4',
					'param_name' => 'columns-lg',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Tablets', 'aidoo-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '3',
					'param_name' => 'columns-md',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Mobile Landscape', 'aidoo-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '2',
					'param_name' => 'columns-sm',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Large image in center', 'aidoo-elements'),
					'param_name' => 'image_center',
					'description' => __('Just work when Columns by 3 ( on Large Desktops and Desktops )','aidoo-elements'),
					'value' => false,
					'dependency' => array(
						'element' => 'layout',
						'value' => 'wp-img-top',
					),
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Show Filter by categories', 'aidoo-elements'),
					'param_name' => 'show_filter',
					'value' => array(__('Yes', 'aidoo-elements') => 'true'),
					'save_always' => true,
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostmasonry'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Filter by categories', 'aidoo-elements'),
					'param_name' => 'filter',
					'value' => array(__('Yes', 'aidoo-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'autocomplete',
					'heading' => __('Categories', 'js_composer'),
					'param_name' => 'category',
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => true,
						'unique_values' => true,
						'display_inline' => true,
						'delay' => 500,
						'auto_focus' => true,
						'values' => $post_categories_values,
					),
					'dependency' => array(
						'element' => 'filter',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Order by', 'aidoo-elements'),
					'param_name' => 'orderby',
					'value' => $order_posts,
					'save_always' => true,
					'description' => sprintf(__('Select how to sort retrieved posts. More at %s.', 'aidoo-elements'), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>'),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Sort order', 'aidoo-elements'),
					'param_name' => 'order',
					'value' => $order_way_values,
					'save_always' => true,
					'description' => sprintf(__('Designates the ascending or descending order. More at %s.', 'aidoo-elements'), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>'),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Extra class name', 'aidoo-elements'),
					'param_name' => 'class',
					'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.', 'aidoo-elements'),
					'save_always' => true,
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Thumbnail size', 'aidoo-elements'),
					'param_name' => 'thumb',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(
						'1:1' => '1-1',
						'4:3' => '4-3',
						'3:4' => '3-4',
						'16:9' => '16-9',
						'9:16' => '9-16',
						'Custom' => 'custom',
					),
					'std' => '4-3',
					'save_always' => true,
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Thumb Width', 'aidoo-elements'),
					'param_name' => 'thumb_w',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => '100',
					'save_always' => true,
					'dependency' => array(
						'element' => 'thumb',
						'value' => array('custom'),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Thumb Height', 'aidoo-elements'),
					'param_name' => 'thumb_h',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => '100',
					'save_always' => true,
					'dependency' => array(
						'element' => 'thumb',
						'value' => array('custom'),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Title tag', 'aidoo-elements'),
					'param_name' => 'title_tag',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(
						'H1' => 'h1',
						'H2' => 'h2',
						'H3' => 'h3',
						'H4' => 'h4',
						'H5' => 'h5',
						'H6' => 'h6',
						'Div' => 'div',
					),
					'std' => 'h4',
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Title link', 'aidoo-elements'),
					'param_name' => 'title_lnk',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(__('Yes', 'aidoo-elements') => 'true'),
					'save_always' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Title character limit of post', 'aidoo-elements'),
					'param_name' => 'title_limit',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => '5',
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Categories', 'aidoo-elements'),
					'param_name' => 'categories',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(__('Show', 'aidoo-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Author', 'aidoo-elements'),
					'param_name' => 'author',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(__('Show', 'aidoo-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Date', 'aidoo-elements'),
					'param_name' => 'datetime',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(__('Show', 'aidoo-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Content character limit of post', 'aidoo-elements'),
					'param_name' => 'limit',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => '15',
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Readmore link', 'aidoo-elements'),
					'param_name' => 'readmore',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => array(__('Show', 'aidoo-elements') => 'true'),
					'save_always' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Readmore text', 'aidoo-elements'),
					'param_name' => 'readmoretxt',
					'group' => __('Content Options', 'aidoo-elements'),
					'value' => 'Read more',
					'save_always' => true,
					'dependency' => array(
						'element' => 'readmore',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Button style', 'aidoo-elements'),
					'param_name' => 'button_style',
					'group' => __('Content Options', 'aidoo-elements'),
					'std' => '',
					'value' => array(
						__('Default', 'aidoo-elements') => 'default',
						__('Button Shadow', 'aidoo-elements') => 'btn-shadow',
					),
					'dependency' => array(
						'element' => 'readmore',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'css_editor',
					'heading' => __('CSS box', 'aidoo-elements'),
					'param_name' => 'css',
					'group' => __('Design Options', 'aidoo-elements'),
					'save_always' => true,
				),
			)
		));

	   
	}
	
	function getCategories() {
		$terms = get_terms('category', 'orderby=name&hide_empty=0');
		if ($terms) {
			foreach ($terms as $key => $term) {
				$dropdown[] = array(
					'label' => $term->name,
					'value' => $term->slug,
				);
			}
		}
		return $dropdown;
	}

	private static function post_loop($query_args, $atts, $style) {
		if ($atts['layout'] == 'wp-list'):
			$columns_xl = $columns_lg = $columns_md = $columns_sm = 1;
		else:
			$columns_xl = (isset($atts['columns-xl']) && $atts['columns-xl']) ? absint($atts['columns-xl']) : 4;
			$columns_lg = (isset($atts['columns-lg']) && $atts['columns-lg']) ? absint($atts['columns-lg']) : $columns_xl;
			$columns_md = (isset($atts['columns-md']) && $atts['columns-md']) ? absint($atts['columns-md']) : $columns_lg;
			$columns_sm = (isset($atts['columns-sm']) && $atts['columns-sm']) ? absint($atts['columns-sm']) : $columns_md;
		endif;
		$rows = (isset($atts['rows']) && absint($atts['rows'])) ? absint($atts['rows']) : 1;

		$nbposts = new WP_Query(apply_filters('widget_posts_args', $query_args));

		ob_start();

		if ($nbposts->have_posts()):
			$postoptions = ' data-cols-xl=' . $columns_xl
					. ' data-cols-lg=' . $columns_lg
					. ' data-cols-md=' . $columns_md
					. ' data-cols-sm=' . $columns_sm
					. ' data-byRow=' . ($rows > 1 ? '0' : '1');
			
			if($atts['style'] == 'wppostmasonry'):
				$postoptions .= ' data-layout=isotope'
						. ' data-layout_mode=mansory';
				if ($atts['show_filter']):
					?>
					<div class="filters-group filters-button-group">
						<?php echo '<a class="filter-btn is-checked" data-filter="*"><span>' . __('All', 'aidoo-elements') . '</span></a>'; ?>
						<?php
						if (isset($atts['category'])):
							$catsfilter = explode(', ', $atts['category']);
							foreach ($catsfilter as $cat) :
								$term = get_term_by('slug', $cat, 'category');
								$name = $term->name;
								echo '<a class="filter-btn" data-filter=".' . $cat . '"><span>' . $name . '</span></a>';
							endforeach;
						else:
							$catsfilter = get_categories();
							foreach ($catsfilter as $cat) :
								echo '<a class="filter-btn" data-filter=".' . $cat->slug . '"><span>' . $cat->name . '</span></a>';
							endforeach;
						endif;
						?>
					</div>
					<?php
				endif;
			endif;
			?>
			<div class="wp-posts <?php if(isset($atts['image_center'])){if($atts['image_center']){ echo 'img_center'; }} ?>"<?php echo esc_attr($postoptions); echo($atts['layout'] != '' ?(' data-nb-layout="'.$atts['layout'].'"') : 'default') ?>>
		
				<?php
				while ($nbposts->have_posts()) :
					$nbposts->the_post();
					
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
					$categories = get_the_category();
					$filtercls = '';
					if ($categories):
						foreach ($categories as $cat):
							$filtercls .= ' ' . $cat->slug;
						endforeach;
					endif;
					?>
					<div class="nb_wp_post nb_<?php echo ($atts['layout'] . ($atts['style'] == 'wppostmasonry' ? (' nb-isotope-item isotope-item' . $filtercls) : '')); ?>">
						<div class="nb_wp_post-i">
							<?php
							if ($atts['layout'] != 'wp-list' && $featured_img_url):
								$thumbsize = '';
								if ($atts['thumb'] == 'custom'):
									$thumbsize = 'width:' . ($atts['thumb_w'] ? $atts['thumb_w'] : '100') . 'px;'
											. 'height:' . ($atts['thumb_h'] ? $atts['thumb_h'] : '100') . 'px;';
								endif;
								?>
								<div class="nb-post-thumb thumb_<?php echo ($atts['thumb']); ?>">
									<div class="nb-post-thumb-i">
										<a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);<?php echo ($thumbsize); ?>"></a>
									</div>
								</div>			

							<?php endif; ?>
							<?php if ($atts['layout'] == 'wp-img-top' && $atts['datetime']): ?>

							<div class="nb-post-date">
								<div class="nb-post-date-i">
									<span class="vc_post_date-day"><?php echo date_i18n('j', strtotime(get_the_date(''))); ?></span>
									<span class="vc_post_date-month"><?php echo date_i18n('M', strtotime(get_the_date(''))); ?></span>
								</div>
							</div>

							<?php endif; ?>
							
							<div class="nb-post-block">
								<div class="nb-post-header">
									<?php
									if ($atts['categories']):
										if ($atts['layout'] != ('wp-img-left' || 'wp-img-top')):
										$cats = get_the_category_list(esc_html__(', ', 'aidoo-elements'));
										echo $cats ? ('<div class="nb-post-cats">' . $cats . '</div>') : '';
										endif;
										if ($atts['layout'] == ('wp-img-left' || 'wp-img-top')):
										$cats = get_the_category_list(esc_html__(', ', 'aidoo-elements'));
										echo $cats ? ('<div class="nb-post-cats">Category ' . $cats . '</div>') : '';
										endif;
									endif;
									?>
									<?php if ($atts['author'] ||  $atts['datetime']): ?>
										<div class="nb-post-meta">

											<?php if ($atts['layout'] != ('wp-img-left' || 'wp-img-top')):?>
												<?php if ($atts['author']): ?>
												<span class="nb-post-author"><?php the_author(); ?></span>
												<?php endif; ?>
											<?php endif; ?>

											<?php if (($atts['layout'] == 'wp-img-left' || $atts['layout'] == 'wp-img-top')):?>
												<?php if ($atts['author']): ?>
												<span class="nb-post-author"><span>By <?php the_author(); ?></span>
												<?php endif; ?>

												<?php if ( $atts['author']): ?>
													<?php if ( $atts['datetime']): ?>
														<span><?php echo date_i18n('d', strtotime(get_the_date(''))); ?> <?php echo date_i18n('F', strtotime(get_the_date(''))); ?>,<?php echo date_i18n('y', strtotime(get_the_date(''))); ?></span>
													<?php endif; ?>
												<?php endif; ?>
												
												<?php if (!$atts['author']): ?>
													<?php if ( $atts['datetime']): ?>
													<span class="nb-post-datetime"><?php echo date_i18n('d', strtotime(get_the_date(''))); ?>,<?php echo date_i18n('F', strtotime(get_the_date(''))); ?>
													</span>
													<?php endif; ?>
												<?php endif; ?>

												<?php if ($atts['author']): ?>
												</span>
												<?php endif; ?>
											<?php endif; ?>


											<?php if ($atts['datetime'] &&  ($atts['layout'] != 'wp-img-top' && $atts['datetime']) &&($atts['layout'] != 'wp-img-left' &&  $atts['datetime'])): ?>
												<span class="nb-post-datetime"><?php echo $atts['timeago'] ? human_time_diff(strtotime(get_the_date()), current_time('timestamp')) : get_the_date(); ?></span>
											<?php endif; ?>

										</div>
									<?php endif; ?>
									<<?php echo ($atts['title_tag'] ? $atts['title_tag'] : 'h4'); ?> class="nb-title-post">
									<?php if ($atts['title_lnk']): ?>
										<a href="<?php the_permalink(); ?>">
											<?php
											if (get_the_title()):
												echo (absint($atts['title_limit']) > 0 ? wp_trim_words(get_the_title(), $atts['title_limit'], '...') : get_the_title());
											else :
												echo get_the_ID();
											endif;
											?>
										</a>
									<?php else: ?>
										<?php
										if (get_the_title()):
											echo (absint($atts['title_limit']) > 0 ? wp_trim_words(get_the_title(), $atts['title_limit'], '...') : get_the_title());
										else :
											echo get_the_ID();
										endif;
										?>
									<?php endif; ?>
									</<?php echo ($atts['title_tag'] ? $atts['title_tag'] : 'h4'); ?>>
								</div>
								<?php if ($atts['readmore'] || $atts['limit']): ?>
								<div class="nb-post-content">
								<?php endif; ?>
								<?php if ($atts['limit'] == '' || absint($atts['limit']) > 0): ?>
									<?php
									if (has_excerpt()) :
										echo '<p>' . (absint($atts['limit']) > 0 ? wp_trim_words(get_the_excerpt(), $atts['limit'], '...') : get_the_excerpt()) . '</p>';
									else :
										echo '<p>' . (absint($atts['limit']) > 0 ? wp_trim_words(get_the_content(), $atts['limit'], '...') : get_the_content()) . '</p>';
									endif;
									?>
								<?php endif; ?>
									<?php if ($atts['readmore']): ?>
										<div class="nb-post-readmore <?php echo $atts['button_style'] == 'btn-shadow' ? $atts['button_style'] : ''; ?>">
											<a class="readmore" href="<?php the_permalink(); ?>"><?php echo ($atts['readmoretxt'] ? $atts['readmoretxt'] : esc_html__('Read more', 'aidoo-elements')); ?></a>
										</div>
									<?php endif; ?>
								<?php if ($atts['readmore'] || $atts['limit']): ?>
								</div>
								<?php endif; ?>
							</div>						
						</div>
					</div>
					<?php
					
				endwhile; // end of the loop. 
				?>
			</div>
			<?php
			
		endif;
		wp_reset_query();

		return ob_get_clean();
	}

	public function aidoo_posts_render($atts) {
		extract(shortcode_atts(
						array(
			'style' => '',
			'image_center' => false,
			'layout' => '',
			'per_page' => '',
			'columns-xl' => '',
			'columns-lg' => '',
			'columns-md' => '',
			'columns-xs' => '',
			'rows' => '',
			'filter' => '',
			'show_filter' => '',
			'category' => '',
			'orderby' => '',
			'order' => '',
			'Show now' => '',
			'class' => '',
			'css' => '',
			'thumb' => '',
			'thumb_w' => '',
			'thumb_h' => '',
			'title_tag' => '',
			'title_lnk' => '',
			'title_limit' => '',
			'categories' => '',
			'author' => '',
			'datetime' => '',
			'timeago' => '',
			'limit' => '15',
			'readmore' => '',
			'readmoretxt' => '',
			'button_style' => 'default',
			), $atts, 'nb_wpposts'
		));


		$tax_query = array(
			array(
				'field' => 'slug',
				'terms' => (($atts['filter'] && isset($atts['category'])) ? $atts['category'] : ''),
			),
		);
		$query_args = array(
			'post_type' => 'post',
			'post_status' => 'publish',
			'posts_per_page' => $atts['per_page'],
			'category_name' => (($atts['filter'] && isset($atts['category'])) ? $atts['category'] : ''),
			'orderby' => $atts['orderby'],
			'order' => $atts['order'],
		);

		$latest_posts = self::post_loop($query_args, $atts, $atts['style']);
		$output = '';
		if ($latest_posts):
			$css_class = 'wpb_content_element nb_wpposts_' . ($atts['style'] ? $atts['style'] : 'default') . ' nb_layout_' . ($atts['layout'] ? $atts['layout'] : 'default');
			$css_class = implode(' ', array($css_class, $class));
			$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $css_class . vc_shortcode_custom_css_class($css, ' '), 'nb_wpposts', $atts);
			$css_class = trim(preg_replace('/\s+/', ' ', $css_class));
			$output = '<div class="' . esc_attr($css_class) . '" >'
					. $latest_posts
					. '</div>';
		endif;

		return $output;
	}
}


new NB_Element_Blog(); 
}

