<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Banner extends WPBakeryShortCode {
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'aidoo_banner_images', array( $this, 'shortcode_banner' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'          => esc_html__( 'Banner Images', 'aidoo-elements' ),
            'base'          => 'aidoo_banner_images',
            'icon'          => 'icon-wpb-wp',
            'category'      => __('Aidoo', 'aidoo-elements'),
            'description'   => esc_html__( 'Display Banner Images.', 'aidoo-elements' ),
            'params'        => array(
                //Title
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Primary Text', 'aidoo-elements' ),
                    'param_name'  => 'txt_primary',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ), 
                array(
                    'heading'    => __( 'Primary Text Font Size', 'aidoo-elements' ),
                    'param_name' => 'txt_primary_font_size',
                    'type'       => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Primary Text Color ', 'aidoo-elements' ),
                    'param_name'  => 'textcolor_custom',
                    'value'       => '',
                    'description' => esc_html__( 'Select the primary text custom color.', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    
                ),

                array(
                        'heading'     => __( 'Image', 'aidoo-elements' ),
                        'param_name'  => 'banner_img',
                        'type'        => 'attach_image',
                ),

                array(
                    'type' => 'checkbox',
                    'heading' => __( 'Show Image As Background', 'aidoo-elements' ),
                    'param_name' => 'show_img_as_background',
                    'edit_field_class' => 'vc_col-xs-12 vc_column',
                ),

                array(
                    'heading'    => __( 'Caption text', 'aidoo-elements' ),
                    'param_name' => 'txt_caption',
                    'type'       => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),                

                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Caption Text Color', 'aidoo-elements' ),
                    'param_name'  => 'caption_text_color',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    
                ),

                array(
                    'heading'     => esc_html__( 'Caption Text Font Size', 'aidoo-elements' ),
                    'param_name'  => 'caption_text_font_size',
                    'type'        => 'textfield',
                    'edit_field_class' => 'vc_col-xs-12 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                    
                ),

                array(
                    'type' => 'checkbox',
                    'heading' => __( 'Show divider', 'aidoo-elements' ),
                    'param_name' => 'show_caption_divider',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),

                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Divider Color ', 'aidoo-elements' ),
                    'param_name'  => 'divider_color',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    
                ),

                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Description', 'aidoo-elements' ),
                    'param_name'  => 'description',
                    'value'       => '',

                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Description Text Color ', 'aidoo-elements' ),
                    'param_name'  => 'textdes_color',
                    'value'       => ''
                ),
                array(
                    'heading'    => __( 'Button Text', 'aidoo-elements' ),
                    'param_name' => 'txt_button',
                    'type'       => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),
                array(
                    'heading'    => __( 'Button Url', 'aidoo-elements' ),
                    'param_name' => 'button_url',
                    'type'       => 'vc_link',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),

                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Button Text Color ', 'aidoo-elements' ),
                    'param_name'  => 'button_text_color',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',          
                ),

                array(
                    'type' => 'checkbox',
                    'heading' => __( 'Show Border Button', 'aidoo-elements' ),
                    'param_name' => 'show_border_button',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',    
                ),

                array(
                    'heading'     => esc_html__( 'Button Text Font Size', 'aidoo-elements' ),
                    'param_name'  => 'button_text_font_size',
                    'type'        => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                    
                ),

                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Border Button Color ', 'aidoo-elements' ),
                    'param_name'  => 'border_button_color',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',          
                ),
                
                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Add link to Title', 'aidoo-elements' ),
                        'param_name' => 'link_to_title',
                        'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),
                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Background White', 'aidoo-elements' ),
                        'param_name' => 'text_info_bg',
                        'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),
                array(
                    'type' => 'checkbox',
                    'heading' => __( 'Text info Background Black', 'aidoo-elements' ),
                    'param_name' => 'text_info_bg_bl',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
            ),
               

                //Alignment
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Text alignment', 'aidoo-elements' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Text at left', 'aidoo-elements' )   => 'text-left',
                        __( 'Text at center', 'aidoo-elements' ) => 'text-center',
                        __( 'Text at right', 'aidoo-elements' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),

                //Alignment
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Text Box Position', 'aidoo-elements' ),
                    'param_name'  => 'text_position',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Top left', 'aidoo-elements' )   => 'top-left',
                        __( 'Top Right', 'aidoo-elements' )   => 'top-right',
                        __( 'Center Center', 'aidoo-elements' ) => 'center-center',
                        __( 'Center Left', 'aidoo-elements' )  => 'center-left',
                        __( 'Center Right', 'aidoo-elements' )  => 'center-right',
                        __( 'Bottom Center', 'aidoo-elements' )  => 'bottom-center',
                        __( 'Bottom Right', 'aidoo-elements' )  => 'bottom-right',
                        __( 'Bottom Left', 'aidoo-elements' )  => 'bottom-left',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),


                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Image Effect', 'aidoo-elements' ),
                    'param_name'  => 'effect_img',
                    'value'       => array(
                        'Choose the effect'     => '',
                        __( 'Zoom In', 'aidoo-elements' )   => 'zoom-in',
                        __( 'Border Inside', 'aidoo-elements' ) => 'border-inside',
                        __( 'Lightning', 'aidoo-elements' ) => 'lightning',
                        __( 'Flashing', 'aidoo-elements' ) => 'flashing',
                        
                    ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom Class', 'aidoo-elements' ),
                    'param_name' => 'custom_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',  
                    'edit_field_class' => 'vc_col-xs-6 vc_column',                  
                ),

                array(
                    'heading'    => __( 'Custom Bottom Box Position', 'aidoo-elements' ),
                    'param_name' => 'custom_bottom_box',
                    'type'       => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'dependency' => array(
                        'element' => 'text_position',
                        'value'   => 'bottom-center',
                    ),
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Custom left Box Position', 'aidoo-elements' ),
                    'param_name' => 'custom_left_box',
                    'type'       => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'dependency' => array(
                        'element' => 'text_position',
                        'value'   => 'center-left',
                    ),
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Custom right Box Position', 'aidoo-elements' ),
                    'param_name' => 'custom_right_box',
                    'type'       => 'textfield',
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'dependency' => array(
                        'element' => 'text_position',
                        'value'   => 'center-right',
                    ),
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Primary text margin top', 'aidoo-elements' ),
                    'param_name' => 'primary_text_margin_top',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Primary text margin bottom', 'aidoo-elements' ),
                    'param_name' => 'primary_text_margin_bottom',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Caption text margin top', 'aidoo-elements' ),
                    'param_name' => 'caption_text_margin_top',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Caption text margin bottom', 'aidoo-elements' ),
                    'param_name' => 'caption_text_margin_bottom',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Divider margin top', 'aidoo-elements' ),
                    'param_name' => 'divider_margin_top',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Devider margin bottom', 'aidoo-elements' ),
                    'param_name' => 'devider_margin_bottom',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Description margin top', 'aidoo-elements' ),
                    'param_name' => 'description_margin_top',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),

                array(
                    'heading'    => __( 'Description margin bottom', 'aidoo-elements' ),
                    'param_name' => 'description_margin_bottom',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),
                array(
                    'heading'    => __( 'Padding wrap', 'aidoo-elements' ),
                    'param_name' => 'padding_wrap_content',
                    'type'       => 'textfield',
                    'group' => __( 'Design', 'aidoo-elements' ),
                    'edit_field_class' => 'vc_col-xs-6 vc_column',
                    'description' => esc_html__('( Example: 15px or 15% )','aidoo-elements'),
                ),
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_banner($atts, $content = null)
    {
        $custom_class ='';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'txt_primary' => '',
                    'txt_caption' => '',
                    'description' => '',
                    'txt_button' => '',
                    'button_url' => '',
                    'link_to_title' => '',
                    'show_caption_divider' => '',
                    'show_img_as_background' => '',
                    'text_info_bg' =>'',
                    'text_info_bg_bl' => '',
                    'text_info_circle' => '',
                    'text_align' => 'text-left',
                    'text_position'=>'',
                    'txt_primary_font_size' => '',
                    'textcolor_custom'         => '',
                    'custom_class' => '',
                    'effect_img' => '',
                    'css' => '',    
                    'banner_img' => '',
                    'custom_bottom_box' =>'',
                    'custom_left_box' =>'',
                    'custom_right_box' =>'',
                    'textdes_color' =>'',
                    'padding_wrap_content' => '5px 20px',
                    'caption_text_color' => '',
                    'divider_color' => '',
                    'button_text_color' => '',
                    'show_border_button' => '',
                    'border_button_color' => '',
                    'caption_text_font_size' => '',
                    'button_text_font_size' => '',
                    'primary_text_margin_top' => '',
                    'primary_text_margin_bottom' => '',
                    'caption_text_margin_top' => '',
                    'caption_text_margin_bottom' => '',
                    'divider_margin_top' => '',
                    'devider_margin_bottom' => '',
                    'description_margin_top' => '',
                    'description_margin_bottom' => '',
                ),
                $atts
            )
        );

        $url = $target = $link_title = $rel ='';
        if( $button_url !='' ){
            $href 		= 	vc_build_link($button_url);
            $url 			= ( isset( $href['url'] ) && $href['url'] !== '' ) ? $href['url']  : '';
            $target 		= ( isset( $href['target'] ) && $href['target'] !== '' ) ? esc_attr( trim( $href['target'] ) ) : '';
            $link_title 	= ( isset( $href['title'] ) && $href['title'] !== '' ) ? esc_attr($href['title']) : '';
            $rel 			= ( isset( $href['rel'] ) && $href['rel'] !== '' ) ? esc_attr($href['rel']) : '';
        }

        if($target !=''){ $target = ' target="'.$target.'"'; }
        if($link_title !=''){ $link_title =' title="'.$link_title.'"';}
        if($rel !=''){ $rel = ' rel="'.$rel.'"';}
        
        $css_class = $content =  $html = $primary_text_css_inline = '';
        $classes = array();

        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'aidoo_banner_images', $atts );

        if($txt_primary_font_size){
            $primary_text_css_inline .= 'font-size:' . $txt_primary_font_size . ';';
        }
        if ( $textcolor_custom ) {
            $primary_text_css_inline .= 'color:' . $textcolor_custom . ';';
        }
        if ( $primary_text_margin_top ) {
            $primary_text_css_inline .= 'margin-top:' . $primary_text_margin_top . ';';
        }
        if ( $primary_text_margin_bottom ) {
            $primary_text_css_inline .= 'margin-bottom:' . $primary_text_margin_bottom . ';';
        }
        if ( $primary_text_css_inline ) {
            $primary_text_css_inline = ' style="' . $primary_text_css_inline . '"';
        }

        $nbfw_txt_info_style ='';
        if($custom_right_box){
            $nbfw_txt_info_style .= 'right:' . $custom_right_box . ';';
        }
        if($custom_left_box){
            $nbfw_txt_info_style .= 'left:' . $custom_left_box . ';';
        }
        if($text_position == 'bottom-center' && $custom_bottom_box){
            $nbfw_txt_info_style .= 'bottom:' . $custom_bottom_box . ';';
        }
        if($padding_wrap_content != ''){
            $nbfw_txt_info_style .= 'padding:' . $padding_wrap_content . ';';
        }
        if($nbfw_txt_info_style){
            $nbfw_txt_info_style ='style="' . $nbfw_txt_info_style . '"';
        }
       
        if($text_align && $text_align <> ''){
            $text_align = $text_align;
        }else{
             $text_align = '';
        }

        if($text_position){
            $text_position = 'p-'.$text_position;
        }else{
            $text_position='';
        }

        $caption_css_inline     = '';
        
        if($caption_text_color) {
            $caption_css_inline .= 'color:'.$caption_text_color . ';';
        }
        if($caption_text_font_size) {
            $caption_css_inline .= 'font-size:'.$caption_text_font_size.';';
        }
        if ( $caption_text_margin_top ) {
            $caption_css_inline .= 'margin-top:' . $caption_text_margin_top . ';';
        }
        if ( $caption_text_margin_bottom ) {
            $caption_css_inline .= 'margin-bottom:' . $caption_text_margin_bottom . ';';
        }
        if($caption_css_inline) {
            $caption_css_inline = ' style="' . $caption_css_inline . '"';
        }

        $divider_css_inline = '';
        
        if($divider_color) {
            $divider_css_inline = 'border-color:'.$divider_color.';';
        }
        if ( $divider_margin_top ) {
            $divider_css_inline .= 'margin-top:' . $divider_margin_top . ';';
        }
        if ( $devider_margin_bottom ) {
            $divider_css_inline .= 'margin-bottom:' . $devider_margin_bottom . ';';
        }
        if($divider_css_inline) {
            $divider_css_inline = ' style="' . $divider_css_inline . '"';
        }

        $description_css_inline = '';
        if($textdes_color){
            $description_css_inline .= 'color:'.$textdes_color.';';
        }
        if ( $description_margin_top ) {
            $description_css_inline .= 'margin-top:' . $description_margin_top . ';';
        }
        if ( $description_margin_bottom ) {
            $description_css_inline .= 'margin-bottom:' . $description_margin_bottom . ';';
        }
        if($description_css_inline) {
            $description_css_inline = ' style="' . $description_css_inline . '"';
        }

        $button_text_css_inline = '';

        if($button_text_color) {
            $button_text_css_inline .= 'color:'.$button_text_color . ';';
        }
        if($button_text_font_size) {
            $button_text_css_inline .= 'font-size:'.$button_text_font_size.';';
        }
        if($border_button_color) {
            $button_text_css_inline .= 'border-color:'.$border_button_color.';';
        }
        
        if($button_text_css_inline) {
            $button_text_css_inline = ' style="' . $button_text_css_inline . '"';
        }

        $show_border_button_class = '';

        if(! $show_border_button) {
            $show_border_button_class = ' no-border';
        }

        $show_bg_class = '';
        $padding_wrap = '';
        if($text_info_bg){
            $show_bg_class =' bg-white';
        }  
        if($text_info_bg_bl){
            $show_bg_class = ' bg-black';
        }

        $src = wp_get_attachment_image_src($banner_img,'full');       

        $bg_image_style =  $show_img_as_background ? "style='background: url(" . esc_url( $src[0] ) . ")  center/cover no-repeat'" : '';
        $has_divider_class = $show_caption_divider ? ' has-divider' : '';

        // Generate HTML code.
        $html .= '<div class="nb-fw banner '.$custom_class.' '.$effect_img.' '.esc_attr( $css_class ).'">';

        $html .= '<div class="nbfw_banner-container" ' . $bg_image_style . ' >';

            if (!$show_img_as_background){
                if($url !='') {
                    $html .='<a class="image-link" href="'. esc_url($url).'" '.$target.' '.$link_title.' '.$rel.'>';
                }
                    $html .= '<img src="' . esc_url($src[0]) . '" alt="banner" />';
                if($url !='') {
                    $html .= '</a>';
                }
            }

        if($url !='') {
            $html .='<a href="'. esc_url($url).'" '.$target.' '.$link_title.' '.$rel.'>';
        }

        $html .= "<div class='info-wrapper" . $show_bg_class . "'>";
        
        if($txt_caption || $txt_primary || $description || $txt_button) {
            $html .= '<div class="nbfw-txt-info '.$text_align.' '.$text_position.'"  '.$nbfw_txt_info_style.'>';
            
            if($txt_primary){
                $html .='<h4 class="txt-primary" '. $primary_text_css_inline .'>';
                    if($link_to_title && $url !=''){
                        //$html .='<a '.$primary_text_css_inline.' href="'. esc_url($url).'" '.$target.' '.$link_title.' '.$rel.'>';
                    }
                    $html .=' '.$txt_primary ;

                    if($link_to_title && $url !=''){
                        //$html .='</a>';
                    }

                $html .='</h4>';
            }

            if($txt_caption){
                $html .='<div class="txt-caption' . $has_divider_class . '"' . $caption_css_inline . '> ' . $txt_caption;
                if($show_caption_divider) $html .= '<span class="txt-caption-divider"' . $divider_css_inline . '></span>';
                $html .= '</div>';
            }

            if($description){
                $html .='<p class="txt-des" '.$description_css_inline.'> '.$description.'</p>';
            }
            if($txt_button && $url !=''){
                // $html .='<a href="'. esc_url($url).'" class="banner-more' . $show_border_button_class . '"' . $button_text_css_inline . '>'.$txt_button.'</a>';
                // $html .='<div class="banner-more' . $show_border_button_class . '"' . $button_text_css_inline . '>'.$txt_button.'</div>';
                $html .='<span class="banner-more' . $show_border_button_class . '"' . $button_text_css_inline . '>'.$txt_button.'</span>';
            }

            $html .= '</div>';
        }

        $html .= '</div>';

        if($url !='') {
            $html .= '</a>';
        }

        $html .= '</div>';
        $html .= '</div>';
        // End HTML code.

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_banner', force_balance_tags($html));
    }
     
} // End Element Class
 
// Element Class Init
new NB_Element_Banner(); 
}
