(function ($, window, document, undefined) {
    'use strict';
    $(function () {
        $(document).ready(function () {
            var $rtl = false;
            if ($('html').attr('dir') == 'rtl') {
                $rtl = true;
            }
            
			$('[data-slide="swipper-slider"]').each(function () {

				var $this           = $(this);
				var datalayout = $this.attr( 'data-nb-layout' );

				//console.log(datalayout);

				if(datalayout=='wp-img-top'){
					var swiper = new Swiper('.swiper-container.wp-img-top',{
						slidesPerView: $(this).attr('data-cols-xl'),
						spaceBetween: parseInt($(this).attr('data-margin')),
						autoplay: $.parseJSON($(this).attr('data-autoplay')),
						pagination: {
						  el: '.pagination_wp-img-top',
						  clickable: true,
						},
						navigation:{
							nextEl: '.next_wp-img-top',
							prevEl: '.prev_wp-img-top',
						},
						breakpoints:{
                            1199:{
								slidesPerView: $(this).attr('data-cols-lg'),
      							spaceBetween: parseInt($(this).attr('data-margin')),
							},
							991:{
								slidesPerView: $(this).attr('data-cols-md'),
      							spaceBetween: 30,
							},
							767:{
								slidesPerView: $(this).attr('data-cols-sm'),
      							spaceBetween: 0,
							}
						}
					});
                }
                if(datalayout=='wp-img-left'){
					var swiper = new Swiper('.swiper-container.wp-img-left',{
						slidesPerView: $(this).attr('data-cols-xl'),
						spaceBetween: parseInt($(this).attr('data-margin')),
						autoplay: $.parseJSON($(this).attr('data-autoplay')),
						pagination: {
						  el: '.pagination_wp-img-left',
						  clickable: true,
						},
						navigation:{
							nextEl: '.next_wp-img-left',
							prevEl: '.prev_wp-img-left',
						},
						breakpoints:{
                            1199:{
								slidesPerView: $(this).attr('data-cols-lg'),
      							spaceBetween: 15,
							},

							991:{
								slidesPerView: $(this).attr('data-cols-md'),
      							spaceBetween: 15,
							},
							767:{
								slidesPerView: $(this).attr('data-cols-sm'),
      							spaceBetween: 0,
							}
						}
					});
                }
                if(datalayout=='wp-content-absolute'){
					var swiper = new Swiper('.swiper-container.wp-content-absolute',{
						slidesPerView: $(this).attr('data-cols-xl'),
						spaceBetween: parseInt($(this).attr('data-margin')),
						autoplay: $.parseJSON($(this).attr('data-autoplay')),
						pagination: {
						  el: '.pagination_wp-content-absolute',
						  clickable: true,
						},
						navigation:{
							nextEl: '.next_wp-content-absolute',
							prevEl: '.prev_wp-content-absolute',
						},
						breakpoints:{
                            1199:{
								slidesPerView: $(this).attr('data-cols-lg'),
      							spaceBetween: 15,
							},

							991:{
								slidesPerView: $(this).attr('data-cols-md'),
      							spaceBetween: 15,
							},
							767:{
								slidesPerView: $(this).attr('data-cols-sm'),
      							spaceBetween: 0,
							}
						}
					});
				}
				
			});
			

            if ($('[data-layout="isotope"]').length) {
                var $originLeft = true;
                if ($rtl) {
                    $originLeft = false;
                }
                $('[data-layout="isotope"]:not(.img_center)').each( function() {
                    var $isotope = $(this).imagesLoaded(function () {
                        $isotope.isotope({
                            itemSelector: '.isotope-item',
                            percentPosition: true,
                            layoutMode: 'masonry',
                            originLeft: $originLeft,
                        });
                    });
                    $(this).prev('.filters-button-group').on('click', '.filter-btn', function () {
                        var filterValue = $(this).attr('data-filter');
                        $isotope.isotope({filter: filterValue});
                        if(($(this).not('.is-checked'))){
                            $(this).parents('.filters-button-group').eq(0).find('.is-checked').removeClass('is-checked');
                            $(this).addClass('is-checked');
                        }
                    });
                });
            }
            
        });
    });

})(jQuery, window, document);
(function($) {
  "use strict";
  if ($(".brands-list").length) {
    var per_page = $(".brands-list").data("owl-options");

    var swiper = new Swiper(".brands-list", {
      slidesPerView: per_page.items,
      spaceBetween: 30,
      loop: per_page.loop,
      breakpoints: {
        991: {
          slidesPerView: per_page.tablet,
        },
        767: {
          slidesPerView: per_page.mobile,
        },
        575: {
          slidesPerView: 1,
        },
      },
    });
  }
})(window.jQuery);

(function($) {

    "use strict";

    $(".uvc-heading.heading-1 .uvc-main-heading").each(function(){
        var text = $(this).children().text();
        var split = text.split(" ");
        var replace = "<span>"+ split[0] +"</span>";
        var change = text.replace(split[0], replace);
        $(this).children().html(change);
    });
    
})(window.jQuery);
(function($) {
    'use trick';
    if($('.instagram').length){
        var item = $('.instagram').data('responsive');

        var swiper = new Swiper('.instagram.swiper-container', {
            slidesPerView: item.desktop,
            spaceBetween: 0,
            loop: false,
            breakpoints:{
                992: {
                    slidesPerView: item.tablet,
                },
                576: {
                    slidesPerView: item.mobile,
                }
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            }
        });
    }
    
})(window.jQuery);

(function($) {

"use strict";

	//===Tab Product===
	var $button = $('#product6 .vc-tab-product-content .cat_img a:first-child button').text();
	$('.vc-tab-product-wrapper').each(function() {

		var $this           = $(this),
			tab_item   		= $this.find('ul li');

		tab_item.click(function(e) {
			
			e.preventDefault();
			tab_item.removeClass('active');
			$(this).addClass('active');

			var $tab_id = $(this).find('a').attr('href');
						
			if( $($tab_id).find('.products').length <= 0 ){

				if(! $this.hasClass('wpt-loading')) {
					$this.addClass('wpt-loading');
					$($tab_id).load( aidoo.ajaxurl, {
						action: 'product_tabs',
					    cat: $($tab_id).attr('data-term_id'),
					    limit: $($tab_id).attr('data-limit'),
					    cat_img: $($tab_id).attr('data-cat-img'),
					    cat_img_align: $($tab_id).attr('data-cat-img-align'),
					    cat_img_urls: $($tab_id).attr('data-cat-img-urls'),
					    cat_img_buttons: $($tab_id).attr('data-cat-img-buttons'),
					    product_type: $($tab_id).attr('data-product-type'),
					    current_lang: $($tab_id).attr('data-lang'),
					}, function() {
						$this.removeClass('wpt-loading');
						$this.find('.vc-tab-product-content .tab-panel').removeClass('panel-active');
						$($tab_id).addClass('panel-active');
						$($tab_id + " .cat_img button").text($button);
					});
				}
			}
			else {
				$this.find('.vc-tab-product-content .tab-panel').removeClass('panel-active');
				$($tab_id).addClass('panel-active');
			}

			return false;
		});
	});

})(window.jQuery);
jQuery(document).ready(function ($) {

	"use strict";
	$(document).on('vc-full-width-row', function() {
		var thu = 0;
		$(".vc-printshop-template-online").each(function() {
			var $this = $(this);

			var per = $this.find( '.swiper-wrapper' ).attr( 'data-per' );
			var color = $this.find( '.swiper-wrapper' ).attr( 'data-color' );

			var swiper = new Swiper('.vc-template-od', {
				slidesPerView: per,
				spaceBetween: 50,
				pagination: {
					el: '.swiper-pagination',
					clickable: true,
				},
				navigation: {
					nextEl: '.swiper-button-next-2',
					prevEl: '.swiper-button-prev-2',
				},
				breakpoints: {
					1920: {
						slidesPerView: per,
					},
					1367: {
						slidesPerView: 1,
					},
				},
			});

			thu++;
			var id_current = 'tod'+thu;
			$this.attr('id',id_current);
			$( "<style>#"+id_current+" .swiper-button-next-2:before, #"+id_current+" .swiper-button-prev-2:before { color: " + color + "; }</style>" ).appendTo( "head" );
		});
		
	});
});
jQuery(document).ready(function ($) {

	"use strict";
	$(document).on('vc-full-width-row', function() {

		$(".vc-aidoo-testimonials").each(function(){

			var $this           = $(this);
			var dataStyle = $this.find( '.vc_testimonial_wrap' ).attr( 'data-style' );
			var styleClass = '.testimonial_' + dataStyle;
			
			if( dataStyle == 'multi_thumb' ) {

                var multiThumbATSelector = styleClass + ' .vc-avatar-testimonial';
                var multiThumbCTSelector = styleClass + ' .vc-content-testimonial';

                var testimonialAvatarSwiper = new Swiper(multiThumbATSelector, {
                    grabCursor: true,
                    initialSlide: 1,
                    slidesPerView: 3,
                    centeredSlides: true,
                    slideToClickedSlide: true,
                    breakpoints: {
                        480: {
                            slidesPerView: 1,
                        },
                    },
                });

                var testimonialContentSwiper = new Swiper(multiThumbCTSelector, {
                    grabCursor: true,
                    initialSlide: 1,
                    slidesPerView: 1,
                    centeredSlides: true,
                    pagination: {
                        el: '.testimonial-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    },
                });

                testimonialAvatarSwiper.on( 'slideChange', function () {

                    var currentIndex = testimonialAvatarSwiper.activeIndex;
                    testimonialContentSwiper.slideTo( currentIndex, 300, false );

                });

                testimonialContentSwiper.on('slideChange', function () {

                    var currentIndex = testimonialContentSwiper.activeIndex;
                    testimonialAvatarSwiper.slideTo( currentIndex, 300, false );

                });

            }

            if( dataStyle == 'multi_thumb_style_1' ) {

                var multiThumbstyle1ATSelector = styleClass + ' .vc-avatar-testimonial';
                var multiThumbstyle1CTSelector = styleClass + ' .vc-content-testimonial';

                var testimonialAvatarSwiper = new Swiper(multiThumbstyle1ATSelector, {
                    grabCursor: true,
                    initialSlide: 1,
                    slidesPerView: 3,
                    centeredSlides: true,
                    slideToClickedSlide: true,
                    breakpoints: {
                        575: {
                            slidesPerView: 1,
                        },
                    },
                });

                var testimonialContentSwiper = new Swiper(multiThumbstyle1CTSelector, {
                    grabCursor: true,
                    initialSlide: 1,
                    slidesPerView: 1,
                    centeredSlides: true,
                    pagination: {
                        el: '.testimonial-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '.swiper-button-next_multi_style_1',
                        prevEl: '.swiper-button-prev_multi_style_1',
                    },
                });

                testimonialAvatarSwiper.on( 'slideChange', function () {

                    var currentIndex = testimonialAvatarSwiper.activeIndex;
                    testimonialContentSwiper.slideTo( currentIndex, 300, false );

                });

                testimonialContentSwiper.on('slideChange', function () {

                    var currentIndex = testimonialContentSwiper.activeIndex;
                    testimonialAvatarSwiper.slideTo( currentIndex, 300, false );

                });

            }

            if( dataStyle == 'single_thumb_style_2' ) {

                var singleThumbstyle2CTSelector = styleClass + ' .vc-content-testimonial';

                var testimonialContentSwiper = new Swiper(singleThumbstyle2CTSelector, {
                    grabCursor: true,
                    slidesPerView: 1,
                    centeredSlides: false,
                    spaceBetween: 30,
                    pagination: {
                        el: '.testimonial-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '.swiper-button-next_style_2',
                        prevEl: '.swiper-button-prev_style_2',
                    },
                });
            }

		});
	});


});
