<?php
/*
Plugin Name: Aidoo Elements
Plugin URI: http://netbaseteam.com/
Description: Prodive all visual composer elements and widgets.
Version: 1.1.1
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
*/

define('TP_ELEMENTS_PATH', plugin_dir_path(__FILE__));
define('TP_ELEMENTS_NAME', plugin_basename(__FILE__));
define('TP_ELEMENTS_URL', plugin_dir_url( __FILE__ ));

class Netbase_Elements
{
    public static function init()
    {
        self::include_function_plugins();
        self::load_widget();
        add_action('vc_before_init', array(__CLASS__, 'load_vc_elements'));
        add_action('wp_enqueue_scripts', array(__CLASS__, 'nb_elements_enqueue_scripts'));
        add_filter('vc_google_fonts_get_fonts_filter', array(__CLASS__, 'nb_helper_vc_fonts'));
    }

    public static function nb_elements_enqueue_scripts() {

        wp_enqueue_style( 'swiper', TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '4.5.0');
        wp_enqueue_script( 'swiper',  TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '4.5.0', true);
        
        wp_enqueue_style( 'nb_elements', TP_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
        if(is_rtl()){
            wp_enqueue_style( 'nb_elements_rtl', TP_ELEMENTS_URL . 'assets/rtl.css', array(), '20180324' ); 
        }
        wp_enqueue_script( 'nb_elements', TP_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );


        wp_enqueue_script( 'equal_height', TP_ELEMENTS_URL . 'assets/vendors/jquery-match-height/jquery.matchHeight-min.js', array(), '0.7.2', true );
        wp_enqueue_script( 'imageload', TP_ELEMENTS_URL . 'assets/vendors/imagesloaded/imagesloaded.pkgd.min.js', array(), '4.1.4', true );
        wp_enqueue_script( 'isotope', TP_ELEMENTS_URL . 'assets/vendors/isotope/isotope.pkgd.min.js', array(), '3.0.6', true );

        wp_enqueue_style( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css', array(), '1.1.0' );
        wp_enqueue_script( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array('jquery'), '1.1.0', true );
        
        

    }

    public static function nb_helper_vc_fonts( $fonts_list ) {
        $poppins->font_family = 'Poppins';
        $poppins->font_types = '300 light regular:300:normal,400 regular:400:normal,500 bold regular:500:normal,600 bold regular:600:normal,700 bold regular:700:normal';
        $poppins->font_styles = 'regular';
        $poppins->font_family_description = esc_html_e( 'Select font family', 'helper' );
        $poppins->font_style_description = esc_html_e( 'Select font styling', 'helper' );
        $fonts_list[] = $poppins;

        return $fonts_list;
    }



    public static function include_function_plugins() {

        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    public static function load_vc_elements() {
        
        require_once( TP_ELEMENTS_PATH . 'vc_elements/testimonials.php' );  
        require_once( TP_ELEMENTS_PATH . 'vc_elements/vc-instagram.php' );  
        require_once( TP_ELEMENTS_PATH . 'vc_elements/banner-images.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/blog.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/product-tabs.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/brands-list.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/product-online-design.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/our-team.php' );
    }

    public static function load_widget() {
        require_once( TP_ELEMENTS_PATH . 'widgets/social-links.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/instagram-widget.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/contact-info.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/recent-blog.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/related-products-widget.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/product_featured.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/author_blog.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/sale_product.php' );
    }
}
Netbase_Elements::init();
