<?php
if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_page-settings',
		'title' => 'Page settings',
		'fields' => array (
			array (
				'key' => 'field_59c87f32cc4c8',
				'label' => 'Title Section',
				'name' => 'page_title_section',
				'type' => 'true_false',
				'instructions' => 'Turn on title section in this page or not',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_59c87fcacc4cb',
				'label' => 'Custom Header',
				'name' => 'page_custom_header',
				'type' => 'true_false',
				'instructions' => 'Switch custom header (logo, menu color...)',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_59c87fa3cc4ca',
				'label' => 'Page Class',
				'name' => 'page_class',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_59c87f57cc4c9',
				'label' => 'Sidebar',
				'name' => 'page_sidebar',
				'type' => 'select',
				'choices' => array (
					'full-width' => 'Full width',
					'left-sidebar' => 'Left sidebar',
					'right-sidebar' => 'Right sidebar',
				),
				'default_value' => 'full-width',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_59c8805ccc4cc',
				'label' => 'Content Width',
				'name' => 'page_content_width',
				'type' => 'number',
				'instructions' => 'Content area width in percent',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_59c87f57cc4c9',
							'operator' => '!=',
							'value' => 'full-width',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => 70,
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => 60,
				'max' => 80,
				'step' => 1,
			),
			array (
				'key' => 'field_59c880b2cc4cd',
				'label' => 'Background color',
				'name' => 'page_bg_color',
				'type' => 'color_picker',
				'default_value' => '',
			),
			array (
				'key' => 'field_59c8816dcc4cf',
				'label' => 'Background Image',
				'name' => 'page_bg_image',
				'type' => 'image',
				'save_format' => 'url',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_59c880d7cc4ce',
				'label' => 'Background Size',
				'name' => 'page_bg_size',
				'type' => 'select',
				'choices' => array (
					'auto' => 'Auto',
					'cover' => 'Cover',
					'contain' => 'Contain',
				),
				'default_value' => 'auto',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_59c8819acc4d0',
				'label' => 'Background Position',
				'name' => 'page_bg_pos',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}

