<?php
/*
Widget Name: Netbaseteam Tabs Widget
Description: Tabs widget by netbaseteam
Author: Netbaseteam
Author URI: http://netbaseteam.com
*/

class NBTSOW_Tabs_Widget extends SiteOrigin_Widget{
    function __construct()
    {
        parent::__construct(
            'nbtsow-tabs-widget',
            esc_html__('NBTSOW Tabs Widget','nbtsow'),
            array(
                'description' => esc_html__('NBT Tabs Widget','nbtsow')
            ),
            array(),
            array(
                'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Title' , 'nbtsow')
                ),
                'name' => array(
                    'type' => 'text',
                    'label' => esc_html__('Name*', 'nbtsow'),
                    'description' => esc_html__('Please enter the name of tabs','nbtsow'),
                    'default' => esc_html__('Tabs_name','nbtsow')
                ),
                'repeater' => array(
                    'type' => 'repeater',
                    'label' => __( 'NBTSOW-Tabs' , 'nbtsow' ),
                    'item_name'  => __( 'NBTSOW-Tab', 'nbtsow' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
                        'tab_title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Tab Title', 'nbtsow'),
                        ),
                        'tab_content' => array(
                            'type' => 'tinymce',
                            'label' => esc_html__('Tab content', 'nbtsow'),
                            'row' => 10,
                            'default_editor' => 'html',
                        )
                    )
                )
            )
        );
    }
    function get_template_variables($instance, $args)
    {
        return array(
            'repeater' => $instance['repeater'],
            'title' => $instance['title'],
            'name' => $instance['name']
        );
    }
    function get_template_name($instance)
    {
        return 'default';
    }
    function get_style_name($instance)
    {
        return '';
    }
}
siteorigin_widget_register('nbtsow-tabs-widget', __FILE__,'NBTSOW_Tabs_Widget');