<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

<div class="udetor-page-title">
    <div class="entry-header container">
	    <div class="col-md-12">
	    <?php	    
	    if ( true == get_theme_mod( 'udetor_woo_general_show_page_title', false ) ) : ?>
	        <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
			<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
			<?php endif; ?>
	    <?php endif; ?>   
	        <?php 
			if ( true != get_theme_mod( 'udetor_woo_general_hidden_breadcrumb', false ) ) :
				Udetor_Core::get_udetor_template('breadcrumbs'); 
			endif;
			?>
		</div>
    </div>  
    
</div>
<div id="content" class="container site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
   <?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>

		<?php while ( have_posts() ) : the_post(); ?>

			<?php wc_get_template_part( 'content', 'single-product' ); ?>

		<?php endwhile; // end of the loop. ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>
    
    <?php
    if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
        get_sidebar();
    } ?>    
    <?php
get_footer(); ?>
