<?php
$menu_id           = $args['$menu_id'];
$settings          = $args['$settings'];
$align             = $settings['align'];
$position = $settings['position'];
$layout_hide_title = $settings['layout_hide_title'] ? true : false;
?>

<div class="udetor-wrapper-mega-menu">
    <div class="field-udetor-icons description">
        <label>Menu Item Icon</label>
        <div class="udetor-field udetor-field-icon <?php if ( empty( $settings['icon'] ) )
			echo esc_attr( 'udetor-field-empty' ) ?>">
            <div class="udetor-icon-selector">
                <div class="choose udetor-open-modal" data-modal="#udetor-megamenu-choose-icons">
					<span class="udetor-preview-icon">
						<?php if ( ! empty( $settings['icon'] ) ): ?>
                            <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
						<?php endif; ?>
					</span>
                    <span class="label">Choose Icon</span>
                </div>
                <span class="udetor-remove"></span>
                <input type="hidden" class="input-icon" value="<?php echo esc_attr( $settings['icon'] ) ?>" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][icon]">
            </div>
        </div>
    </div>

    <div class="field-udetor-sub-align description">
        <label>Menu Item Alignment</label>
        <div class="udetor-field">
            <label>
                <input type="radio" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][align]" value="left" <?php checked( $align, 'left' ) ?>>
                <input type="radio" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][align]" value="right" <?php checked( $align, 'right' ) ?>>
            </label>
        </div>
    </div>
    <div class="wp-clearfix"></div>
    <div class="field-udetor-sub-position description">
        <label>Custom Position Sub Menu</label>
        <div class="udetor-field">
            <label>
                <input type="radio" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][position]" value="default" <?php checked( $position, 'default' ) ?>>                
                <input type="radio" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][position]" value="left" <?php checked( $position, 'left' ) ?>>
                <input type="radio" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][position]" value="center" <?php checked( $position, 'center' ) ?>>
                <input type="radio" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][position]" value="right" <?php checked( $position, 'right' ) ?>>
            </label>
        </div>
    </div>

    <div class="wp-clearfix"></div>

    <div class="field-udetor-mega-menu description" data-type="<?php echo esc_attr( $settings['layout'] ) ?>" id="udetor-mega-menu-item-<?php echo esc_attr( $menu_id ) ?>">
        <div class="udetor-menu-extra-field">
            <label>Select Menu Type<a class="udetor-open-modal help dashicons dashicons-editor-help" href="<?php echo esc_url( Udetor_MegaMenu_Manager::get_link_iframe_how_to_use() ) ?>" title="How to use Udetor Menu Type?"></a></label>
            <div class="udetor-field udetor-field-layout">
                <div class="udetor-row">
                    <div class="udetor-col-50">
                        <select title="Type layout" class="udetor-field-type-layout" id="udetor-mega-menu-type-<?php echo esc_attr( $menu_id ) ?>" name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][layout]">
                            <option value="default" <?php selected( 'default', $settings['layout'] ) ?>>Layout Default</option>
                            <option value="column" <?php selected( 'column', $settings['layout'] ) ?>>Layout Columns</option>
                            <option value="builder" <?php selected( 'builder', $settings['layout'] ) ?>>Layout Mega Designer</option>
                        </select>
                    </div>
                    <div class="udetor-col-50">
                        <label class="udetor-layout-hide-title udetor-hide">
                            <input type="checkbox" <?php checked( true, $layout_hide_title ) ?>
                                   name="udetor-mega-menu[<?php echo esc_attr( $menu_id ) ?>][layout_hide_title]">
                            Hide column title?
                        </label>

                        <button type="button" class="udetor-open-modal button button-primary open-builder udetor-hide" data-modal="#udetor-mega-menu-layout-builder">Open</button>
                    </div>
                </div>

                <div class="udetor-waring-builder udetor-hide"><?php esc_html_e( 'Content in layout builder will override sub-items', 'udetor' ) ?></div>
            </div>
        </div>
    </div>
</div>