<?php

// General
$items = apply_filters( 'nbcore_tiny_mce_formats_items', array(
    array(
        'title'    => esc_html__( 'Theme Button', 'udetor' ),
        'selector' => 'a',
        'classes'  => 'theme-button',
    ),
    array(
        'title'   => esc_html__( 'Highlight', 'udetor' ),
        'inline'  => 'span',
        'classes' => 'text-highlight',
    ),
    array(
        'title'   => esc_html__( 'Thin Font', 'udetor' ),
        'inline'  => 'span',
        'classes' => 'thin-font'
    ),
    array(
        'title'   => esc_html__( 'White Text', 'udetor' ),
        'inline'  => 'span',
        'classes' => 'white-text'
    ),
    array(
        'title'    => esc_html__( 'Check List', 'udetor' ),
        'selector' => 'ul',
        'classes'  => 'check-list'
    ),
) );

// Dropcaps
$dropcaps = apply_filters( 'nbcore_tiny_mce_formats_dropcaps', array(
    array(
        'title'   => esc_html__( 'Dropcap', 'udetor' ),
        'inline'  => 'span',
        'classes' => 'dropcap',
    ),
    array(
        'title'   => esc_html__( 'Boxed Dropcap', 'udetor' ),
        'inline'  => 'span',
        'classes' => 'dropcap boxed',
    ),
    
    array(
        'title' => esc_html__('Bordered','udetor'),
        'inline' => 'span',
        'classes' => 'dropcap dropcap-borders',
        
    ),
    array(
        'title' => esc_html__('Border Right','udetor'),
        'inline' => 'span',
        'classes' => 'dropcap dropcap-border-right',
        
    ),
    array(
        'title' => esc_html__('Background Dark','udetor'),
        'inline' => 'span',
        'classes' => 'dropcap dropcap-bg-dark',
        
    ),
    array(
        'title' => esc_html__('Background Light','udetor'),
        'inline' => 'span',
        'classes' => 'dropcap dropcap-bg-light',        
    ),
    array(
        'title' => esc_html__('Background Primary Color','udetor'),
        'inline' => 'span',
        'classes' => 'dropcap dropcap-bg-primary-color br3',        
    ),
    array(
        'title' => esc_html__('Color Green','udetor'),
        'inline' => 'span',
        'classes' => 'dropcap color-green',        
    ),
) );

// Headline
$headlines = apply_filters( 'nbcore_tiny_mce_formats_headlines', array(
    array(
        'title' => esc_html__('Left','udetor'),
        'selector' => 'h1,h2,h3,h4,h5,h6',
        'classes' => 'headline headline-left',
        'wrapper' => true,
    ),
    array(
        'title' => esc_html__('Center','udetor'),
        'selector' => 'h1,h2,h3,h4,h5,h6',
        'classes' => 'headline headline-center',
        'wrapper' => true,
    ),
    array(
        'title' => esc_html__('Right','udetor'),
        'selector' => 'h1,h2,h3,h4,h5,h6',
        'classes' => 'headline headline-right',
        'wrapper' => true,
    ),
) );

$container = apply_filters('nbcore_tiny_mce_formats_container', array(
    array(
        'title' => esc_html__('Borders','udetor'),
        'items' => array(
            array(
                'title' => esc_html__('Top','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-border-top'
            ),
            array(
                'title' => esc_html__('Bottom','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-border-bottom'
            ),
            array(
                'title' => esc_html__('Left','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-border-left'
            ),
            array(
                'title' => esc_html__('Right','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-border-right'
            ),
            array(
                'title' => esc_html__('All','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-border-all'
            ),
        ),
    ),
    array(
        'title' => esc_html__('Background','udetor'),
        'items' => array(
            array(
                'title' => esc_html__('Dark','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-bg block-bg-dark',
            ),
            array(
                'title' => esc_html__('Light','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-bg block-bg-light'
            ),
        ),
    ),
    array(
        'title' => esc_html__('Float','udetor'),
        'items' => array(
            array(
                'title' => esc_html__('Left','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-float-left'
            ),
            array(
                'title' => esc_html__('Right','udetor'),
                'block' => 'div',
                'classes' => 'content-block block-float-right'
            ),
        ),
    ),
));



// Array of list menu items config for dropdown
$format_menu = array(

    array(
        'title' => esc_html__( 'Dropcaps', 'udetor' ),
        'items' => $dropcaps,
    ),

    
    array(
        'title' => esc_html__( 'Netbase Styles', 'udetor' ),
        'items' => $items,
    ),

    

    array(
        'title' => esc_html__('Headline','udetor'),
        'items' => $headlines,
    ),

    array(
        'title' => esc_html__('Highlight','udetor'),
        'inline' => 'span',
        'wrapper' => true,
        'classes' => 'highlight',
    ),

    array(
        'title' => esc_html__('Container','udetor'),
        'items' => $container,
    ),
);

