<?php
$udetor_sep   = '/';
$udetor_class = 'udetor-breadcrumbs clear';
$udetor_home  = esc_html__( 'Home', 'udetor' );
$udetor_blog  = esc_html__( 'Blog', 'udetor' );
$udetor_shop  = esc_html__( 'Shop', 'udetor' );

// Get the query & post information
global $post, $wp_query;

// Get post category
$udetor_category = get_the_category();


// Get product category
$udetor_product_cat = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

if ( $udetor_product_cat ) {
	$udetor_tax_title = $udetor_product_cat->name;
}

$udetor_output = '';

// Build the breadcrums
$udetor_output .= '<ul class="' . esc_attr( $udetor_class ) . '">';

// Do not display on the homepage
if ( ! is_front_page() ) {

	if ( is_home() ) {

		// Home page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_blog . ' </li>';

	} elseif ( function_exists( 'is_shop' ) && is_shop() ) {

		$udetor_output .= '<li class="item">' . $udetor_shop . '</li>';

	} else if ( function_exists( 'is_product' ) && is_product() || function_exists( 'is_cart' ) && is_cart() || function_exists( 'is_checkout' ) && is_checkout()  || function_exists( 'is_account_page' ) && is_account_page() ) {

		$udetor_output .= '<li class="item"><a href="' . esc_url( get_post_type_archive_link( 'product' ) ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_shop . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';
		$udetor_output .= '<li class="item">' . get_the_title() . '</li>';

	} else if ( function_exists( 'is_product_category' ) && is_product_category() ) {

		$udetor_output .= '<li class="item"><a href="' . esc_url( get_post_type_archive_link( 'product' ) ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_shop . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';
		$udetor_output .= '<li class="item">' . $udetor_tax_title . '</li>';

	} else if ( function_exists( 'is_product_tag' ) && is_product_tag() ) {

		$udetor_output .= '<li class="item"><a href="' . esc_url( get_post_type_archive_link( 'product' ) ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_shop . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';
		$udetor_output .= '<li class="item">' . $udetor_tax_title . '</li>';

	} else if ( is_post_type_archive() ) {

		// Home page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		ob_start();
		post_type_archive_title();

		$udetor_output .= '<li class="item current">' . ob_get_clean() . '</li>';

	}
	else if ( is_single() ) {

		$post_type = get_post_type();
		// Home page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		if ( 'post' == $post_type && ! empty( $udetor_category ) ) {
			// First post category
			$udetor_output .= '<li class="item"><a href="' . esc_url( get_category_link( $udetor_category[0]->term_id ) ) . '" title="' . esc_attr( $udetor_category[0]->cat_name ) . '">' . $udetor_category[0]->cat_name . '</a></li>';
			$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		} 


		$udetor_output .= '<li class="item current">' . get_the_title() . '</li>';

	} else if ( is_archive() && is_tax() && ! is_category() && ! is_tag() ) {
		$tax_object = get_queried_object();

		// Home page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		if ( ! empty( $tax_object ) ) {
			$udetor_output .= '<li class="item current">' . esc_html( $tax_object->name ) . '</li>';
		}

	} else if ( is_category() ) {
		// Home page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Category page
		$udetor_output .= '<li class="item current">' . single_cat_title( '', false ) . '</li>';

	} else if ( is_page() ) {

		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Standard page
		if ( $post->post_parent ) {

			// If child page, get parents
			$udetor_anc = get_post_ancestors( $post->ID );

			// Get parents in the right order
			$udetor_anc = array_reverse( $udetor_anc );

			// Parent page loop
			foreach ( $udetor_anc as $udetor_ancestor ) {
				$udetor_parents = '<li class="item"><a href="' . esc_url( get_permalink( $udetor_ancestor ) ) . '" title="' . esc_attr( get_the_title( $udetor_ancestor ) ) . '">' . get_the_title( $udetor_ancestor ) . '</a></li>';
				$udetor_parents .= '<li class="separator"> ' . $udetor_sep . ' </li>';
			}

			// Display parent pages
			$udetor_output .= $udetor_parents;

			// Current page
			$udetor_output .= '<li class="item current"> ' . get_the_title() . '</li>';

		} else {

			// Just display current page if not parents
			$udetor_output .= '<li class="item current"> ' . get_the_title() . '</li>';

		}

	} else if ( is_tag() ) {

		// Tag page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Get tag information
		$udetor_term_id  = get_query_var( 'tag_id' );
		$udetor_taxonomy = 'post_tag';
		$udetor_args     = 'include=' . $udetor_term_id;
		$udetor_terms    = get_terms( $udetor_taxonomy, $udetor_args );

		// Display the tag name
		if ( isset( $udetor_terms[0]->name ) )
			$udetor_output .= '<li class="item current">' . $udetor_terms[0]->name . '</li>';

	} elseif ( is_day() ) {

		// Year link
		$udetor_output .= '<li class="item"><a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . esc_html__( ' Archives', 'udetor' ) . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Month link
		$udetor_output .= '<li class="item"><a href="' . esc_url( get_month_link( get_the_time('Y'), get_the_time( 'm' ) ) ) . '" title="' . esc_attr( get_the_time( 'M' ) ) . '">' . get_the_time( 'M' ) . esc_html__( ' Archives', 'udetor' ) . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Day display
		$udetor_output .= '<li class="item current"> ' . get_the_time('jS') . ' ' . get_the_time('M') . esc_html__( ' Archives', 'udetor' ) . '</li>';

	} else if ( is_month() ) {

		// Month Archive

		// Year link
		$udetor_output .= '<li class="item"><a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . esc_html__( ' Archives', 'udetor' ) . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Month display
		$udetor_output .= '<li class="item">' . get_the_time( 'M' ) . esc_html__( ' Archives', 'udetor' ) . '</li>';

	} else if ( is_year() ) {

		// Display year archive
		$udetor_output .= '<li class="item current">' . get_the_time('Y') . esc_html__( 'Archives', 'udetor' ) . '</li>';

	} else if ( is_author() ) {

		// Home page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';

		// Get the author information
		global $author;
		$udetor_userdata = get_userdata( $author );

		// Display author name
		$udetor_output .= '<li class="item current">' . esc_html__( 'Author: ', 'udetor' ) . '<a href="' . get_author_posts_url( $udetor_userdata->ID, $udetor_userdata->nice_name ) . '">' . $udetor_userdata->display_name . '</a></li>';

	} else if ( get_query_var( 'paged' ) ) {

		// Paginated archives
		$udetor_output .= '<li class="item current">' .  esc_html__( 'Page', 'udetor' ) . ' ' . get_query_var( 'paged', 'udetor' ) . '</li>';

	} else if ( is_search() ) {

		// Search results page
		$udetor_output .= '<li class="item current">' .  esc_html__( 'Keyword: ', 'udetor' ) . get_search_query() . '</li>';

	} elseif ( is_404() ) {

		// 404 page
		$udetor_output .= '<li class="item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $udetor_home ) . '">' . $udetor_home . '</a></li>';
		$udetor_output .= '<li class="separator"> ' . $udetor_sep . ' </li>';
		$udetor_output .= '<li class="item current">' . esc_html__( 'Error 404', 'udetor' ) . '</li>';
	}

}

$udetor_output .= '</ul>';

echo wp_kses_post( $udetor_output );
