<?php
/**
 * @version    1.0.1
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

class Udetor_Woocommerce {
	/**
	 * Variable to hold the initialization state.
	 *
	 * @var  boolean
	 */
	protected static $initialized = false;

	/**
	 * Initialize functions.
	 *
	 * @return  void
	 */
	public static function initialize() {
		// Do nothing if start functions already initialized.
		if ( self::$initialized ) {
			return;
		}
          
        add_action( 'wp_enqueue_scripts'   , array( __CLASS__, 'udetor_ajax_scripts_loader' ));		
		add_action( 'after_setup_theme', array( __CLASS__, 'udetor_woo_setup' ) );  
        add_action( 'woocommerce_before_shop_loop_item',  array( __CLASS__, 'udetor_wrap_product_item' ) , 0 );
        add_action( 'woocommerce_after_shop_loop_item',   array( __CLASS__, 'udetor_wrap_product_item_close' ) , 40 );
        
        add_action('woocommerce_after_shop_loop_item', array(__CLASS__, 'udetor_wishlist_button'), 8);
        add_action('woocommerce_after_shop_loop_item', array(__CLASS__, 'udetor_quickview_button'),11);
        
        add_action('woocommerce_single_product_summary', array(__CLASS__, 'udetor_template_single_availability'), 11);
        add_filter('loop_shop_columns', array( __CLASS__, 'udetor_loop_columns' ) );
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
        
        add_action( 'wp_ajax_udetor_quickview', array( __CLASS__, 'udetor_quickview' )  );
        add_action( 'wp_ajax_nopriv_udetor_quickview', array( __CLASS__, 'udetor_quickview' ) );        
        add_action( 'udetor_woo_product_summary_quickview', 'woocommerce_template_single_rating', 10 );
        add_action( 'udetor_woo_product_summary_quickview', 'woocommerce_template_single_price', 10 );
        add_action( 'udetor_woo_product_summary_quickview', 'woocommerce_template_single_excerpt', 20 );
        add_action( 'udetor_woo_product_summary_quickview', 'woocommerce_template_single_add_to_cart', 30 );

        /*custom position rating*/
        remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
        add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 12 );

        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
        add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 9 );

        add_action( 'woocommerce_before_shop_loop',  array( __CLASS__, 'udetor_woo_sorting_wrapper' ),   9 );
        add_action( 'woocommerce_before_shop_loop',  array( __CLASS__, 'udetor_woo_switch_layout' ),   21 );
        add_action( 'woocommerce_before_shop_loop',  array( __CLASS__, 'udetor_woo_sorting_wrapper_close' ), 31 );

        /*add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );*/

        /*add input quantity shop loop */
        add_action( 'woocommerce_after_shop_loop_item', array( __CLASS__,  'custom_quantity_field_archive' ), 0, 9 );
        add_action( 'init', array( __CLASS__,  'custom_add_to_cart_quantity_handler') );
        
        $woo_detail_layout = get_theme_mod('udetor_woo_detail_layout','no-sidebar'); 

        if ( $woo_detail_layout == 'right-sidebar' || $woo_detail_layout == 'left-sidebar' ) {
            add_filter( 'woocommerce_output_related_products_args', array( __CLASS__,  'udetor_related_products_args') );
        }

        /**
         * Cart fragment
         *
         * @see udetor_cart_link_fragment()
         */
        if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '2.3', '>=' ) ) {
            add_filter( 'woocommerce_add_to_cart_fragments', array( __CLASS__,  'udetor_cart_link_fragment') );
        } else {
            add_filter( 'add_to_cart_fragments', array( __CLASS__,  'udetor_cart_link_fragment') );
        }        
        
		// State that initialization completed.
		self::$initialized = true;
	}

    public static function udetor_header_cart_mobile() {
        if ( class_exists( 'WooCommerce' )  ) {
          
        ?>
        <div class="site-header-cart">
                <a class="cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'udetor' ); ?>">
                <?php echo wp_kses_post( WC()->cart->get_cart_subtotal() ); ?> <span class="count"><?php echo wp_kses_data( sprintf( _n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'udetor' ), WC()->cart->get_cart_contents_count() ) );?></span>
            </a>
        </div>           
        
        <?php
        }
    }
    

    /**
     * Cart Fragments
     * Ensure cart contents update when products are added to the cart via AJAX
     *
     * @param  array $fragments Fragments to refresh via AJAX.
     * @return array            Fragments to refresh via AJAX
     */

    public static function udetor_cart_link_fragment( $fragments ) {
        global $woocommerce;

        ob_start();
        ?>
            <a class="cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'udetor' ); ?>">
                <?php echo wp_kses_post( WC()->cart->get_cart_subtotal() ); ?> <span class="count"><?php echo wp_kses_data( sprintf( _n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'udetor' ), WC()->cart->get_cart_contents_count() ) );?></span>
            </a>
        <?php
        $fragments['a.cart-contents'] = ob_get_clean();

        ob_start();
        ?>
            <a class="footer-cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'udetor' ); ?>">
                <span class="count"><?php echo wp_kses_data( sprintf( _n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'udetor' ), WC()->cart->get_cart_contents_count() ) );?></span>
            </a>
        <?php
        $fragments['a.footer-cart-contents'] = ob_get_clean();

        return $fragments;
    }    
    

    /**
     * Change number of related products output
     */ 
    public static function udetor_related_products_args( $args ) {
        $args['posts_per_page'] = 3; // 3 related products
        $args['columns'] = 3; // arranged in 3 columns
        return $args;
    }
    
    public static function custom_quantity_field_archive() {
        //global $product;
        $product = wc_get_product( get_the_ID() );
        if ( ! $product->is_sold_individually() && 'variable' != $product->get_type() && $product->is_purchasable() ) {
            woocommerce_quantity_input( array( 'min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity() ) );
        }
    }

    /**
     * Add requires JavaScript.
     */
    public static function custom_add_to_cart_quantity_handler() {
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
            wc_enqueue_js( '
                jQuery( ".post-type-archive-product" ).on( "click", ".quantity input", function() {
                    return false;
                });
                jQuery( ".post-type-archive-product" ).on( "change input", ".quantity .qty", function() {
                    var add_to_cart_button = jQuery( this ).parents( ".product" ).find( ".add_to_cart_button" );
                    // For AJAX add-to-cart actions
                    add_to_cart_button.data( "quantity", jQuery( this ).val() );
                    // For non-AJAX add-to-cart actions
                    add_to_cart_button.attr( "href", "?add-to-cart=" + add_to_cart_button.attr( "data-product_id" ) + "&quantity=" + jQuery( this ).val() );
                });
            ' );
        }
    }    

    public static function udetor_woo_sorting_wrapper() {
            echo '<div class="udetor-woo-sorting">';
    }
    
    public static function udetor_woo_sorting_wrapper_close() {
            echo '</div>';
    }

    public static function udetor_woo_switch_layout()  {
        echo '<div class="switch-layout udetor-switch"><a href="#" class="list switchToGrid  switch-active"><i class="fa fa-th-large"></i></a><a href="#" class="grid switchToList"><i class="fa fa-list-ul"></i></a></div>';  
    }
    
    public static function udetor_woo_setup() {
        // Declare WooCommerce support
        add_theme_support( 'woocommerce' );
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );
    }

    public static function udetor_template_single_availability(){
        global $product;

        $product_stock = self::udetor_product_get_availability();
        $availability_text = empty($product_stock['availability'])?esc_html__('Available In Stock', 'udetor'):esc_attr($product_stock['availability']);
        ?>  
            <p class="availability stock <?php echo esc_attr($product_stock['class']); ?>" data-original="<?php echo esc_attr($availability_text) ?>" data-class="<?php echo esc_attr($product_stock['class']) ?>"><span><?php echo esc_html($availability_text); ?></span></p> 
        <?php
    }

    public static function udetor_product_get_availability(){
        global $product;
        $availability = $class = '';
        if ( ! $product->is_in_stock() ) {
            $availability = esc_html__( 'Out of stock', 'udetor' );
        } elseif ( $product->managing_stock() && $product->is_on_backorder( 1 ) ) {
            $availability = esc_html__( 'Available on backorder', 'udetor' );
        } elseif ( $product->managing_stock() ) {
            $availability = wc_format_stock_for_display( $product );
        } else {
            $availability = '';
        }
        
        if ( ! $product->is_in_stock() ) {
            $class = 'out-of-stock';
        } elseif ( $product->managing_stock() && $product->is_on_backorder( 1 ) ) {
            $class = 'available-on-backorder';
        } else {
            $class = 'in-stock';
        }

        return array( 'availability' => $availability, 'class' => $class );
    }

    public static function udetor_ajax_scripts_loader(){        
        wp_enqueue_script( 'udetor_quickview',  get_template_directory_uri() . '/assets/udetor/js/udetor_quickview.js', array( 'jquery' ), '', true );
        wp_localize_script( 'udetor_quickview', 'udetor_wp_vars', array(
        'ajaxUrl' => admin_url( 'admin-ajax.php' )
        ));
        
    }
    public static function udetor_loop_columns() {
       $column = get_theme_mod('udetor_woo_archive_grid_columns','three-columns' );
       if($column == 'two-columns'){
        return 2;
       }elseif($column == 'four-columns'){
        return 4;
       }else{return 3; }
       
     }
     // WooCommerce Quick View Ajax Helpers
    public static function udetor_quickview() {
        global $post, $product, $woocommerce;
        $udetor_prod_id = $_POST["productid"];
        $post = get_post( $udetor_prod_id );
        $product = get_product( $udetor_prod_id );
        ob_start();

        wc_get_template( 'content-product-udetor-quickview.php' );

        $udetor_output = ob_get_contents();
        ob_end_clean();
        print( $udetor_output);
        die();
    }

    public static function udetor_shop_classes(){
        $classes = array();

        if ((is_shop() || is_product_category() || is_product_tag()) ) {
            $classes['shop_columns'] = get_theme_mod('udetor_woo_archive_grid_columns','three-columns' );
        }

        echo implode(' ', $classes);
    }
    public static function udetor_wrap_product_item() {
        ?><div class="product-wrap-item"><?php
    }
    public static function udetor_wrap_product_item_close() {
        ?></div><?php
    }

    public static function udetor_wishlist_button()
    {
        if ( class_exists( 'YITH_WCWL' ) ) {
            echo '<div class="udetor-wishlist-btn">' . do_shortcode( '[yith_wcwl_add_to_wishlist]' ) . '</div>';
        }
    }
    public static function udetor_quickview_button(){
        global $post, $product, $woocommerce;
        echo '<a href="#" class="udetor-quick-view" data-id="'.$post->ID.'"><i class="fa fa-search-plus"></i></a>';
    }
	
}