<?php
class Udetor_Widgets_Upcoming_Events_Espresso extends WP_Widget {
	function __construct() {
		$widget_ops  = array(
			'description' => esc_html__( 'Displays the upcoming events espresso', 'udetor' )
		);

		$control_ops = array(
			'width'  => 'auto',
			'height' => 'auto'
		);

		parent::__construct( 'udetor_upcoming_events_espresso', esc_html__( 'Udetor - Upcoming Events Espresso', 'udetor' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title     = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$time      = $instance['time'] ? '1' : '0';
		$date      = $instance['date'] ? '1' : '0';		
		$limit     = empty( $instance['limit'] ) ? 5 : ( int ) $instance['limit'];

		echo wp_kses_post( $before_widget );

		if ( ! empty( $title ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}
        
        if ( is_plugin_active( 'event-espresso-decaf/espresso.php' ) ) {
        	global $post;
	        if ( $post instanceof WP_Post ) {
	            $where = array(
	                'status' => array( 'IN', array( 'publish', 'sold_out' ) )
	            );
	            
	            $where['Datetime.DTT_EVT_end'] = array( '>=', EEM_Datetime::instance()->current_time_for_query( 'DTT_EVT_end' ) );
	            
	            $events = EE_Registry::instance()->load_model( 'Event' )->get_all( array(
	                    $where,
	                    'limit' => $limit > 0 ? '0,' . $limit : '0,10',
	                    'order_by' => 'Datetime.DTT_EVT_start',
	                    'order' => 'ASC',
	                    'group_by' => 'EVT_ID'
	            ));    
	            ob_start(); 
	            if ( ! empty( $events )) {  
	            echo '<ul class="widget-lst">';                 
	                    foreach ( $events as $event ) {
	                        if ( $event instanceof EE_Event && ( !is_single() || $post->ID != $event->ID() ) ) {
	                            
	                            $event_url = apply_filters( 'FHEE_EEW_Upcoming_Events__widget__event_url', $event->get_permalink(), $event );
	                            $desc = $event->short_description( 20 );
	                            $date_format = ! empty( $date_format ) ? $date_format : get_option( 'date_format' );
	                            $time_format = ! empty( $time_format ) ? $time_format : get_option( 'time_format' );
	                            $date_format = apply_filters( 'FHEE__espresso_list_of_event_dates__date_format', $date_format );
	                            $time_format = apply_filters( 'FHEE__espresso_list_of_event_dates__time_format', $time_format );
	                            $datetimes = EEH_Event_View::get_all_date_obj( $event->ID());   
	                                             
	                            echo '<li>';
	                                $image_size = 'udetor-sidebar-thumb';

	                                if ( has_post_thumbnail( $event->ID() ) && $image_size != 'none' ) {
	                                    echo '<div class="widget-lst-thumb"><a class="ee-upcoming-events-widget-img" href="' . $event_url . '">' . get_the_post_thumbnail( $event->ID(), $image_size ) . '</a></div>';
	                                    }
	                                
	                                    echo '<div class="widget-lst-info thumb">';
	                                    	echo '<a class="widget-lst-title" href="' . $event_url . '">' . $event->name() . '</a>';
	                                        
	                                        if ( is_array( $datetimes ) && ! empty( $datetimes )) {
	                                                foreach ( $datetimes as $datetime ) {
	                                                    if ( $datetime instanceof EE_Datetime ) {                     
	                                                        if ($date) {
	                                                        	$start = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_start', 'j M, Y' ) );         
	                                                        	echo '<div class="widget-lst-date">'.$start.'</div>';
	                                                        }
	                                                        
	                                                        if($time){
	                                                        	echo '<div class="udetor-event-timerange">' . $datetime->time_range( $time_format ) . '</div>';                                                    	
	                                                        }
	                                                        
	                                                    }
	                                                }
	                                        }

	                                    echo '</div>';
	                               
	                            echo '</li>';	                           
	                        }
	                    }
	            echo '</ul>';       
	                    
	                }   
	        }
    	}
		
		echo wp_kses_post( $after_widget );
	}

	function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['time']  = ! empty( $new_instance['time'] ) ? 1 : 0;
		$instance['date']  = ! empty( $new_instance['date'] ) ? 1 : 0;
		
		$instance['limit'] = strip_tags( $new_instance['limit'] );
		
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'title' => '', 'thumbtype' => 'thumbnail', 'limit' => 5 ) );
		$title    = strip_tags( $instance['title'] );
		$time     = isset( $instance['time'] ) ? ( bool ) $instance['time'] : true;

		$date = isset( $instance['date'] ) ? ( bool ) $instance['date'] : true;		
		$limit    = ( int ) $instance['limit'];		

	?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'time' ) ); ?>"<?php checked( $time ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>"><?php esc_html_e( 'Show Time', 'udetor' ); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'date' ) ); ?>"<?php checked( $date ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'date' ) ); ?>"><?php esc_html_e( 'Show date', 'udetor' ); ?></label>
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'limit' ) ); ?>" type="number" value="<?php echo esc_attr( $limit ); ?>" />
		</p>

	<?php
	}
}
