<?php
class Udetor_Widgets_Recent_Posts extends WP_Widget {
	function __construct() {
		$widget_ops  = array(
			'description' => esc_html__( 'Displays the recent posts', 'udetor' )
		);

		$control_ops = array(
			'width'  => 'auto',
			'height' => 'auto'
		);

		parent::__construct( 'recent_posts', esc_html__( 'Udetor - Recent Posts', 'udetor' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title     = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$time      = $instance['time'] ? '1' : '0';
		$thumbtype = empty( $instance['thumbtype'] ) ? 'thumbnail' : $instance['thumbtype'];
		$limit     = empty( $instance['limit'] ) ? 5 : ( int ) $instance['limit'];

		$style         = empty( $instance['style'] ) ? 'list' : $instance['style'];
		$pagination      = $instance['pagination'] ? '1' : '0';
		$hidden_title_post= $instance['hidden_title_post'] ? '1' : '0';
		$columns = empty( $instance['columns'] ) ? 1 : ( int ) $instance['columns'];

		$columnstablet = empty( $instance['columnstablet'] ) ? 2 : ( int ) $instance['columnstablet'];

		echo wp_kses_post( $before_widget );

		if ( ! empty( $title ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}

		$the_query = new WP_Query(
			array(
				'posts_per_page'      => $limit,
				'no_found_rows'       => true,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true,
				'tax_query'      => array(
					array(
						'taxonomy' => 'category',
						'field'    => 'term_id',
						'terms'    => $instance['cats']
					)
				),
				'suppress_filters' => true,
			)
		);
		

		if($style == 'slider'){
			$classes = $attr = array();
			if ( $pagination == 1 ) {
                $attr[] = '"dots": "true"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"ades": "' . ( int ) $columnstablet . '"';
            }
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }
            $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
            echo '<ul class="'. esc_attr( implode( ' ', $classes ) ) .'" '.$data_owlcarousel.'>';
            	while( $the_query->have_posts() ) :
					$the_query->the_post();	
					$title  = get_the_title();
					$url    = esc_url(get_permalink());
					$img    = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'udetor-blog-thumb' );
					$format = get_post_format();
					echo '<li>';
						if ( has_post_thumbnail() ) :
							echo '<div class="widget-recent-posts-slider-thumb aethumb">';
							echo '<a href="'. esc_url( $url ).'"><img  src="'.esc_url( $img[0] ).'" alt="'. esc_attr( $title ).'" /></a>';
							echo '</div>';						
						endif;					
					?>
					<?php if($hidden_title_post != 1): ?>
						<a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr( $title ); ?>" class="widget-lst-title">
					<?php echo esc_html( $title ); ?></a>
					<?php endif; ?>
						<?php if ( $time == true ) : ?>
							<time><?php echo get_the_date( 'M j, Y' ); ?></time>
						<?php endif; ?>

					<?php

					echo '</li>';
				endwhile;
				wp_reset_postdata();
            echo '</ul>';

		} else{
		?>
			<ul class="widget-lst recent-posts">
				<?php
				while( $the_query->have_posts() ) :
						$the_query->the_post();

						$title  = get_the_title();
						$url    = esc_url(get_permalink());
						$img    = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'udetor-sidebar-thumb' );
						$format = get_post_format();
				?>
				<li class="fc">
					<?php if ( 'thumbnail' == $thumbtype ) : 
							if ( has_post_thumbnail() ) : ?>
								<div class="widget-lst-thumb">
									<a href="<?php echo esc_url( $url ); ?>" class="entry-thumb" >
										<img class="br-2" src="<?php echo esc_url( $img[0] ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
									</a>
								</div>
							<?php
							endif;
						?>
						<div class="widget-lst-info thumb">
					<?php elseif ( 'post_format' == $thumbtype ) : 
								switch ( $format ) :
									case 'gallery' :
										echo '<i class="fa fa-image"></i>';
										break;
									case 'audio' :
										echo '<i class="fa fa-music"></i>';
										break;
									case 'video' :
										echo '<i class="fa fa-play-circle-o"></i>';
										break;
									case 'quote' :
										echo '<i class="fa fa-quote-left"></i>';
										break;
									default :
										echo '<i class="fa fa-edit"></i>';
									break;
								endswitch;
							?>
						
						<div class="widget-lst-info">
					<?php endif; ?>
						<?php if($hidden_title_post != 1): ?>
						<a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr( $title ); ?>" class="widget-lst-title"><?php echo esc_html( $title ); ?></a>
						<?php endif; ?>
						<?php if ( $time == true ) : ?>
							<time><?php echo get_the_date(); ?></time>
						<?php endif; ?>
					</div>
				</li>

				<?php
					endwhile;
					wp_reset_postdata();
				?>
			</ul>

		<?php
		}
		
		echo wp_kses_post( $after_widget );
	}

	function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['time']  = ! empty( $new_instance['time'] ) ? 1 : 0;
		$instance['cats']  = $new_instance['cats'];
		$instance['limit'] = strip_tags( $new_instance['limit'] );
		if ( in_array( $new_instance['thumbtype'], array( 'thumbnail', 'post_format' ) ) ) {
			$instance['thumbtype'] = $new_instance['thumbtype'];
		} else {
			$instance['thumbtype'] = 'thumbnail';
		}
		$instance['columns'] = strip_tags( $new_instance['columns'] );
		$instance['columnstablet'] = strip_tags( $new_instance['columnstablet'] );
		if ( in_array( $new_instance['style'], array( 'list', 'slider' ) ) ) {
			$instance['style'] = $new_instance['style'];
		} else {
			$instance['style'] = 'list';
		}
		$instance['pagination']       = ! empty( $new_instance['pagination'] ) ? 1 : 0;
		$instance['hidden_title_post']       = ! empty( $new_instance['hidden_title_post'] ) ? 1 : 0;

		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'title' => '', 'thumbtype' => 'thumbnail', 'limit' => 5,'style' =>'list','columns'=>1,'columnstablet' => 2 ) );
		$title    = strip_tags( $instance['title'] );
		$time     = isset( $instance['time'] ) ? ( bool ) $instance['time'] : true;
		$cats     = isset( $instance['cats'] ) ? $instance['cats'] : array();
		$limit    = ( int ) $instance['limit'];
		$style  = esc_attr( $instance['style'] );
		$pagination     = isset( $instance['pagination'] ) ? ( bool ) $instance['pagination'] : true;
		$hidden_title_post = isset( $instance['hidden_title_post'] ) ? ( bool ) $instance['hidden_title_post'] : false;
		$columns  = ( int ) $instance['columns'];
		$columnstablet = ( int ) $instance['columnstablet'];

		$categories = get_categories( 'orderby=name&hide_empty=0' );

	?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'time' ) ); ?>"<?php checked( $time ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>"><?php esc_html_e( 'Show Date', 'udetor' ); ?></label>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'cat' ) ); ?>"><?php esc_html_e( 'Which Categories to show ?', 'udetor' ); ?></label>
			<select class="widefat" multiple="multiple" id="<?php echo esc_attr( $this->get_field_id( 'cats' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cats' ) ); ?>[]">
				<?php foreach ( $categories as $category ) : ?>
					<option value="<?php echo esc_attr( $category->term_id ); ?>"<?php echo in_array( $category->term_id, $cats ) ? ' selected="selected"':''; ?>><?php echo esc_html( $category->name ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'thumbtype' ) ); ?>"><?php esc_html_e( 'Thumbnail Type:', 'udetor' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'thumbtype' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'thumbtype' ) ); ?>" class="widefat">
				<option value="thumbnail"<?php selected( $instance['thumbtype'], 'thumbnail' ); ?>><?php esc_html_e( 'Image', 'udetor' ); ?></option>
				<option value="post_format"<?php selected( $instance['thumbtype'], 'post_format' ); ?>><?php esc_html_e( 'Icon', 'udetor' ); ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'limit' ) ); ?>" type="number" value="<?php echo esc_attr( $limit ); ?>" />
		</p>

		<p>
	      <input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'hidden_title_post' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'hidden_title_post' ) ); ?>"<?php checked( $hidden_title_post ); ?> />
	      <label for="<?php echo esc_attr( $this->get_field_id( 'hidden_title_post' ) ); ?>"><?php esc_html_e( 'Hidden Title Post', 'udetor' ); ?></label>
	    </p>
		<p>
	      <label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php esc_html_e( 'Select style:', 'udetor' ); ?></label><br />
	      <select class="widefat wr-style" id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" >
	        <option value="list" <?php echo ( ( $style == 'list' ) ? 'selected="selected"' : NULL ); ?>><?php esc_html_e( 'List', 'udetor' ); ?></option>
	        <option value="slider" <?php echo ( ( $style == 'slider' ) ? 'selected="selected"' : NULL ); ?>><?php esc_html_e( 'Slider', 'udetor' ); ?></option>
	        
	      </select>
	    </p>
	    <label><?php esc_html_e( 'Config with Style slider', 'udetor' ); ?></label>
	    <p>
	      <label for="<?php echo esc_attr( $this->get_field_id( 'columns' ) ); ?>"><?php esc_html_e( 'Columns (1-5):', 'udetor' ); ?></label>
	      <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'columns' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'columns' ) ); ?>" type="number" min="1" max="5" step="1" value="<?php echo esc_attr( $columns ); ?>" />
	    </p>
	    <p>
	      <input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'pagination' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'pagination' ) ); ?>"<?php checked( $pagination ); ?> />
	      <label for="<?php echo esc_attr( $this->get_field_id( 'pagination' ) ); ?>"><?php esc_html_e( 'Enable Pagination', 'udetor' ); ?></label>
	    </p>
	    <p>
	      <label for="<?php echo esc_attr( $this->get_field_id( 'columnstablet' ) ); ?>"><?php esc_html_e( 'Columns (1-5):', 'udetor' ); ?></label>
	      <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'columnstablet' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'columnstablet' ) ); ?>" type="number" min="1" max="5" step="1" value="<?php echo esc_attr( $columnstablet ); ?>" />
	    </p>
	<?php
	}
}
