<?php
/**
 * Posts List
 */
class Udetor_Widgets_Posts extends WP_Widget {

  public function __construct() {
    $widget_details = array(
      'classname' => 'udetor_widget_posts',
      'description' => esc_html__( 'Display a list of your posts.', 'udetor' )
    );
    parent::__construct( 'udetor_widget_posts', esc_html__( 'Udetor - Posts', 'udetor' ), $widget_details );
  }

  public function widget( $args, $instance ) {

    if ( ! isset( $args['widget_id'] ) ) {
      $args['widget_id'] = $this->id;
    }

    $widget_id          = $args['widget_id'];
    $layout             = 'slider';    
    $posts_per_page     = 5;    

    $posts_args = array(
      'posts_per_page'      => $posts_per_page,     
      'no_found_rows'       => true,
      'post_status'         => 'publish',
      'ignore_sticky_posts' => true
    );
    $posts = new WP_Query( $posts_args );

    if ($posts->have_posts()) {

      $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';      
      $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

      echo wp_kses_post( $before_widget );

      if ( ! empty( $title ) ) {
            echo wp_kses_post( $before_title . $title . $after_title );
        } 
      if ($layout == 'slider') { ?>

        <div class="owl-container owl-flip">
          <div class="owl-carousel">
            <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>

              <?php $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_ID(), 'square'); ?>

              <div class="owl-slide">
                <article <?php post_class('overlay overlay-ratio overlay-ratio-vertical'); ?> style="background-image: url(<?php echo esc_url( $thumbnail[0] ) ; ?>)">
                  <div class="overlay-container">
                    <div class="overlay-content">                      
                      <h2><?php the_title(); ?></h2>                      
                    </div>
                  </div>
                  <a href="<?php the_permalink(); ?>" class="overlay-link"></a>
                </article>
              </div>

            <?php endwhile; ?>

          </div>
          <div class="owl-dots"></div>
        </div>

      <?php } elseif ($layout == 'list') { ?>

        <ul class="<?php echo esc_attr($layout); ?>">
        <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>
          <li>

            <article class="media">
              <div class="media-left">
                <a href="<?php the_permalink(); ?>" class="post-thumbnail">
                  <?php the_post_thumbnail('mini'); ?>
                </a>
              </div>
              <div class="media-body">
                <h4 class="media-heading"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h4>
                <?php the_post_meta($post_meta, $post_meta_compact); ?>
              </div>
            </article>

          </li>

        <?php endwhile; ?>
        </ul>

      <?php } elseif ($layout == 'numbered') { ?>

        <ul class="<?php echo esc_attr($layout); ?>">
        <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>
          <li>
            <article class="media">
              <div class="media-left">
                <a href="<?php the_permalink(); ?>" class="post-thumbnail">
                  <?php the_post_thumbnail('mini'); ?>
                  <span class="post-number-wrap">
                    <span class="post-number">
                      <span><?php print($posts->current_post +1); ?></span>
                      <span><i class="icon icon-arrow-right"></i></span>
                    </span>
                  </span>
                </a>
              </div>
              <div class="media-body">
                <h4 class="media-heading"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h4>
                <?php the_post_meta($post_meta, $post_meta_compact); ?>
              </div>
            </article>
          </li>

        <?php endwhile; ?>
        </ul>
      <?php }  
      echo wp_kses_post( $after_widget );

    }

    wp_reset_postdata();

  }

  public function form( $instance ) {

    $title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';

    ?>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'udetor' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

    <?php    
  }

  public function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title'] = sanitize_text_field( $new_instance['title'] );
    return $instance;
  }
}
