<?php
class Udetor_Widgets_Latest_Courses extends WP_Widget {
	function __construct() {
		$widget_ops  = array(
			'description' => esc_html__( 'Displays the latest courses', 'udetor' )
		);

		$control_ops = array(
			'width'  => 'auto',
			'height' => 'auto'
		);

		parent::__construct( 'udetor_latest_courses', esc_html__( 'Udetor - Latest Courses', 'udetor' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title     = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$time      = $instance['time'] ? '1' : '0';
		$author      = $instance['author'] ? '1' : '0';		
		$hidden_thumb = $instance['hidden_thumb'] ? '1' : '0';
		$limit     = empty( $instance['limit'] ) ? 5 : ( int ) $instance['limit'];

		echo wp_kses_post( $before_widget );

		if ( ! empty( $title ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}		

		$args_courses = array(
            'numberposts' => $limit,
            'offset' => 0,            
            'post_type' => 'sfwd-courses',
            'post_status' => 'publish',
            'suppress_filters' => true
        );

        $dataposts = wp_get_recent_posts($args_courses);

        if ($dataposts) {
        	echo '<ul class="widget-lst">';
            foreach ($dataposts as $key => $value) {            	
            	?>
            	<li>
            	<?php if (has_post_thumbnail($value['ID']) && $hidden_thumb != true ): ?>
                    <div class="widget-lst-thumb">
                        <a href="<?php echo esc_url( get_permalink($value['ID']) ); ?>">
                            <?php echo get_the_post_thumbnail($value['ID'], 'udetor-sidebar-thumb'); ?>
                        </a>
                    </div>
                    <div class="widget-lst-info thumb">
                <?php else: ?>
                	<div class="widget-lst-info">
                <?php endif; ?>
	                
		            	<a href="<?php echo esc_url( get_permalink($value['ID']) ); ?>" class="widget-lst-title">
		                    <?php echo esc_html($value['post_title']); ?>
		                </a>
		                <?php 
		                if($author == true):
		                	echo '<span class="widget-lst-author">' . esc_html__('By: ','udetor') . get_the_author() . '</span>';
		            	endif;
		                if ( $time == true ) :
		                	echo '<span class="widget-lst-date">' . esc_html(get_the_date()) . '</span>';		
		                endif;                
		                ?> 
	                </div>           
				
                </li>
            	<?php
            }
            echo '</ul>';
        }
		
		echo wp_kses_post( $after_widget );
	}

	function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['time']  = ! empty( $new_instance['time'] ) ? 1 : 0;
		$instance['author']  = ! empty( $new_instance['author'] ) ? 1 : 0;
		$instance['hidden_thumb']  = ! empty( $new_instance['hidden_thumb'] ) ? 1 : 0;	
		
		$instance['limit'] = strip_tags( $new_instance['limit'] );		
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'title' => '', 'thumbtype' => 'thumbnail', 'limit' => 5 ) );
		$title    = strip_tags( $instance['title'] );
		$time     = isset( $instance['time'] ) ? ( bool ) $instance['time'] : true;
		$author = isset( $instance['author'] ) ? ( bool ) $instance['author'] : true;
		$hidden_thumb = isset( $instance['hidden_thumb'] ) ? ( bool ) $instance['hidden_thumb'] : false;
		
		$limit    = ( int ) $instance['limit'];

	?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'time' ) ); ?>"<?php checked( $time ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>"><?php esc_html_e( 'Show Date', 'udetor' ); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'author' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'author' ) ); ?>"<?php checked( $author ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'author' ) ); ?>"><?php esc_html_e( 'Show author', 'udetor' ); ?></label>
		</p>

		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'hidden_thumb' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'hidden_thumb' ) ); ?>"<?php checked( $hidden_thumb ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'hidden_thumb' ) ); ?>"><?php esc_html_e( 'Hidden Thumbnail', 'udetor' ); ?></label>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'limit' ) ); ?>" type="number" value="<?php echo esc_attr( $limit ); ?>" />
		</p>
	<?php
	}
}
