<?php
/**
 * Filter Courses widget
 */
class Udetor_Widgets_Filter_Courses extends WP_Widget {

	/**
	 * Holds widget settings defaults, populated in constructor.
	 *
	 * @var array
	 */
	protected $defaults;

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->defaults = array(
			'title'           => '',
		);

		parent::__construct(
			'udetor_filter_courses',
			esc_html__( 'Udetor - Filter Courses', 'udetor' ),
			array(
				'classname'     => 'udetor-filter-courses-widget',
				'description' => esc_html__( 'Add Filter Courses For Site', 'udetor' ),
			)
		);
	}

	/**
	 * Display widget
	 *
	 * @param array   $args     Sidebar configuration
	 * @param array   $instance Widget settings
	 */
	public function widget( $args, $instance ) {
		if ( is_archive() ) :
		$showcat      = '1';
		if(isset($instance['showcat'])){
			$showcat      = $instance['showcat'] ? '1' : '0';
		}

		$showtype      = '1';
		if(isset($instance['showtype'])){
			$showtype      = $instance['showtype'] ? '1' : '0';
		}

		$showskill      = '1';
		if(isset($instance['showskill'])){
			$showskill      = $instance['showskill'] ? '1' : '0';
		}
		

		$instance = wp_parse_args( $instance, $this->defaults );

		$terms =  get_terms('course_category');

		// Get price type item
		$query = new WP_Query( array(
			'post_type'      => 'sfwd-courses',
			'posts_per_page' => -1,
		) );
		$types = array();
		while ( $query->have_posts() ) : $query->the_post();
			$info = get_post_meta( $query->post->ID, '_sfwd-courses', true );
			if ( ! in_array( $info['sfwd-courses_course_price_type'], $types ) ) {
				$types[] = $info['sfwd-courses_course_price_type'];
			}
		endwhile;

		$skill = array();
		while ( $query->have_posts() ) : $query->the_post();
			$info = get_post_meta( $query->post->ID, 'course_skill_lever', true );			
			if($info !=''){
				$skill[] = $info;
			}			
		endwhile;
		$skill = array_unique($skill);

		if( ! empty( $terms )  || ! empty( $types ) ) {

			echo $args ['before_widget'];
			if ( $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) ) {
				echo $args ['before_title'] . $title . $args ['after_title'];
			}
			echo '<div class="filter-removal-buttons"></div>';

			if ( ! empty( $terms ) ) :
				?>
				<?php if ( $showcat == true ) : ?>
				<h4 class="widget-subtitle"><?php esc_html_e( 'Categories', 'udetor' ) ?></h4>
				<ul class="list-style">
					<li class="cat-item cat_current" data-slug="all"><a href="#"><?php esc_html_e( 'All', 'udetor' ); ?></a></li>
					<?php
					Udetor_Filter_Courses::list_categories( );
					?>
				</ul>
				<?php endif; ?>
			<?php endif; ?>
			<?php if ( ! empty( $types ) ): ?>
				<?php if ( $showtype == true ) : ?>
				<h4 class="widget-subtitle"><?php esc_html_e( 'Course Type', 'udetor' ) ?></h4>
				<ul class="list-style">
					<li class="type-item type_current"><a href="#" data="all"><?php esc_html_e( 'All', 'udetor' ); ?></a></li>
					<?php foreach ( $types as $type ) : ?>
						<?php
						switch ( $type ) {
							case 'free':
								$type_text = esc_html__( 'Free', 'udetor' );
								break;
							case 'open':
								$type_text = esc_html__( 'Open', 'udetor' );
								break;
							case 'closed':
								$type_text = esc_html__( 'Closed', 'udetor' );
								break;
							case 'paynow':
								$type_text = esc_html__( 'Paid', 'udetor' );
								break;
							case 'subscribe':
								$type_text = esc_html__( 'Recurring', 'udetor' );
								break;
						}
						?>
						<li class="type-item"><a href="#" data="<?php echo $type; ?>"><?php echo $type_text; ?></a></li>
					<?php endforeach; ?>
				</ul>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ( ! empty( $skill ) ): ?>
				<?php if ( $showskill == true ) : ?>
				<h4 class="widget-subtitle"><?php esc_html_e( 'Course skill levels', 'udetor' ) ?></h4>
				<ul class="list-style">
					<li class="skill-item skill_current"><a href="#" data="all"><?php esc_html_e( 'All', 'udetor' ); ?></a></li>
					<?php foreach ( $skill as $skill_s ) : ?>
						<li class="skill-item"><a href="#" data="<?php echo $skill_s; ?>"><?php echo $skill_s; ?></a></li>
					<?php endforeach; ?>
				</ul>
				<?php endif; ?>
			<?php endif; ?>
			<?php
			echo $args ['after_widget'];
		}
		endif;

	}

	/**
	 * Update widget
	 *
	 * @param array   $new_instance New widget settings
	 * @param array   $old_instance Old widget settings
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ) {
		$instance                    = $old_instance;
		$instance['title']           = strip_tags( $new_instance['title'] );

		$instance['showcat']  = ! empty( $new_instance['showcat'] ) ? 1 : 0;
		$instance['showtype']  = ! empty( $new_instance['showtype'] ) ? 1 : 0;
		$instance['showskill']  = ! empty( $new_instance['showskill'] ) ? 1 : 0;

		return $instance;
	}

	/**
	 * Display widget settings
	 *
	 * @param array   $instance Widget settings
	 * @return void
	 */
	public function form( $instance ) {
		$instance = wp_parse_args( $instance, $this->defaults );
		$showcat     = isset( $instance['showcat'] ) ? ( bool ) $instance['showcat'] : true;

		$showtype     = isset( $instance['showtype'] ) ? ( bool ) $instance['showtype'] : true;
		$showskill     = isset( $instance['showskill'] ) ? ( bool ) $instance['showskill'] : true;
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'udetor' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'showcat' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'showcat' ) ); ?>"<?php checked( $showcat ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'showcat' ) ); ?>"><?php esc_html_e( 'Show Filter Category', 'udetor' ); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'showtype' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'showtype' ) ); ?>"<?php checked( $showtype ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'showtype' ) ); ?>"><?php esc_html_e( 'Show Filter Course Type', 'udetor' ); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'showskill' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'showskill' ) ); ?>"<?php checked( $showskill ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'showskill' ) ); ?>"><?php esc_html_e( 'Show Filter Course skill levels', 'udetor' ); ?></label>
		</p>
		<?php
	}

}
