<?php
class Udetor_Widgets_Contact_Info extends WP_Widget {

	function __construct() {
        $widget_ops  = array(
            'description' => esc_html__( 'Displays the Infomation Contact', 'udetor' )
        );

        $control_ops = array(
            'width'  => 'auto',
            'height' => 'auto'
        );

        parent::__construct( 'udetor_contact_info', esc_html__( 'Udetor - Contact Info', 'udetor' ), $widget_ops, $control_ops );
    }
    /**
     * How to display the widget on the screen.
     */
    function widget($args, $instance) {
        extract($args);       

        $title     = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );      
        $showsocial      = $instance['showsocial'] ? '1' : '0';
        $street1 = $instance['street1'];
        $phone = $instance['phone'];
        $email = $instance['email'];
        $infodes = $instance['infodes'];

        $custom_class = empty( $instance['custom_class'] ) ? '' : $instance['custom_class'];

        echo wp_kses_post( $before_widget );

        if ( ! empty( $title ) ) {
            echo wp_kses_post( $before_title . $title . $after_title );
        }       

         if ( ! empty( $infodes ) ) {
            echo '<p>'.$infodes.'</p>';
         }

    
        echo '<ul class="info '.$custom_class.'">';
			
			if (!empty($street1)){
                echo '<li>';                
                echo '<i class="fa fa-home"></i>';
                echo '<span class="street1">'. esc_html( $street1 ).'</span>';
                echo '</li>';
            }	        
            
            if (!empty($phone)){
                echo '<li><i class="fa fa-phone"></i>';
                echo '<span class="phone">'. esc_html($phone ).'</span>';
                echo '</li>';
            }            
             
			if (!empty($email)){
                echo '<li><i class="fa fa-envelope"></i>';           
                echo '<span class="email"><a href="mailto:'. esc_html($email).'" title="send mail">'. esc_html($email ).'</a></span>';
                echo '</li>';
             }							
			
		echo '</ul>'; 
        
        if ( $showsocial == true ) : 
            $show_contact_social = get_theme_mod( 'udetor_social_on', array( 'facebook', 'twitter', 'google' ) );

                        if ( ! empty( $show_contact_social ) && is_array( $show_contact_social ) ) {
                            echo '<div class="social-link-footer">';
                            foreach ( $show_contact_social as $part ) { ?>
                                <?php if(get_theme_mod('udetor_acc_'.$part)!=''): ?>

                                <a href="<?php echo esc_attr( get_theme_mod('udetor_acc_'.$part) ); ?>">
                                    <i class="fa fa-<?php echo esc_html( $part );  ?>"></i>      
                                </a>            
                                <?php
                                endif;
                            }
                            echo '</div>';
                        }
                        
                        
        endif;
        
        echo wp_kses_post( $after_widget );
    }

    /**
     * Update the widget settings.
     */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;

        /* Strip tags to remove HTML (important for text inputs). */
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['infodes'] = strip_tags($new_instance['infodes']);       
        $instance['custom_class'] = strip_tags($new_instance['custom_class']);        

        $instance['street1'] = strip_tags($new_instance['street1']);
        
        $instance['phone'] = strip_tags($new_instance['phone']);
        $instance['email'] = strip_tags($new_instance['email']);
        $instance['showsocial']  = ! empty( $new_instance['showsocial'] ) ? 1 : 0;

        return $instance;
    }

    /**
     * Displays the widget settings controls on the widget panel.
     * Make use of the get_field_id() and get_field_name() function
     * when creating your form elements. This handles the confusing stuff.
     */
    function form($instance) {

        /* Set up some default widget settings. */
        $showsocial     = isset( $instance['showsocial'] ) ? ( bool ) $instance['showsocial'] : true;
        $defaults = array(
            'title' => '', 
            'street1' => '', 
            'phone' => '', 'email' => '','custom_class' =>'');
        $instance = wp_parse_args((array)$instance, $defaults); ?>

        <!-- Widget Title: Text Input -->
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'udetor'); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($instance['title']); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('infodes')); ?>"><?php esc_html_e('Description:', 'udetor'); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('infodes')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('infodes')); ?>" value="<?php echo esc_attr($instance['infodes']); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('street1')); ?>"><?php esc_html_e('Address:', 'udetor'); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('street1')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('street1')); ?>" value="<?php echo esc_attr($instance['street1']); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'udetor'); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('phone')); ?>" value="<?php echo esc_attr($instance['phone']); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'udetor'); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('email')); ?>" value="<?php echo esc_attr($instance['email']); ?>"/>
        </p>
        <p>
            <input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'showsocial' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'showsocial' ) ); ?>"<?php checked( $showsocial ); ?> />
            <label for="<?php echo esc_attr( $this->get_field_id( 'showsocial' ) ); ?>"><?php esc_html_e( 'Show Social', 'udetor' ); ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('custom_class')); ?>"><?php esc_html_e('Custom Class:', 'udetor'); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('custom_class')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('custom_class')); ?>" value="<?php echo esc_attr($instance['custom_class']); ?>"/>
        </p>
    <?php
    }
}
?>