<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Plug additional thumbnails into Admin.
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Thumbnails {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if (self::$initialized) {
            return;
        }
        
        // Register actions to do something.
        add_action('after_setup_theme', array(__CLASS__, 'udetor_image_size'));
        
        // State that initialization completed.
        self::$initialized = true;
    }
    
    /**
     * Enable support for Post Thumbnails on posts and pages.
     *
     * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
     */
    public static function udetor_image_size() {
        
        add_theme_support('post-thumbnails');
    
        add_image_size( 'udetor-sidebar-thumb', 101, 70, true ); // Hard Crop Mode
        add_image_size( 'udetor-homepage-thumb', 220, 180 ); // Soft Crop Mode
        add_image_size( 'udetor-singlepost-thumb', 590, 9999 ); // Unlimited Height Mode
        add_image_size('udetor-course-thumb', 320, 287, array('center', 'center'));
        add_image_size('udetor-blog-thumb', 370, 271, array('center', 'center'));
    }
}