<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */
class Udetor_Template_Tags {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }        
        // Register actions to do something.
        add_action( 'edit_category', array( __CLASS__, 'udetor_category_transient_flusher' ) );
        add_action( 'save_post', array( __CLASS__, 'udetor_category_transient_flusher' ) );
    
        // State that initialization completed.
        self::$initialized = true;
    }

    /**
     * Prints HTML with meta information for the current post-date/time and author.
     */
    public static function udetor_posted_on() {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
        }        
        $time_string = sprintf( $time_string,
            esc_attr( get_the_date( 'c' ) ),
            esc_html( get_the_date() ),
            esc_attr( get_the_modified_date( 'c' ) ),
            esc_html( get_the_modified_date() )
        );        
        $posted_on = sprintf(
            esc_html_x( 'Posted on %s', 'post date', 'udetor' ),
            '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
        );        
        $byline = sprintf(
            esc_html_x( 'by %s', 'post author', 'udetor' ),
            '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
        );        
        echo '<span class="posted-on">' . $posted_on . '</span><span class="byline"> ' . $byline . '</span>'; 
        
    }

     public static function udetor_posted_meta() {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

        if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
        }

        $time_string = sprintf( $time_string,
            esc_attr( get_the_date( 'c' ) ),
            get_the_date(),
            esc_attr( get_the_modified_date( 'c' ) ),
            get_the_modified_date()
        );

        $byline = sprintf(
            esc_html_x( '%s', 'post author', 'udetor' ),
            '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
        );       
        
        echo '<span class="byline"> ' . $byline . '</span>';          

        printf( '<span class="posted-on"><i class="fa fa-calendar" aria-hidden="true"></i>%1$s <a href="%2$s" rel="bookmark">%3$s</a></span>',
            _x( '', 'Used before publish date.', 'udetor' ),
            esc_url( get_permalink() ),
            $time_string
        );   
        
    }

    public static function udetor_posted_on_meta() {
        if ( is_sticky( ) ) {
            echo wp_kses(__('<span class="nbt-sticky-post">Sticky</span>', 'udetor'), array('span' => array('class' => array())));
        }
        if(get_the_author() && true == get_theme_mod('udetor_blog_tags_show_author_info', true )){
            $byline = sprintf(
                _x( '<i class="fa fa-user"></i> %s', 'post author', 'udetor' ),
                '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
            );
            echo '<span class="byline">'. $byline . '</span>';
        }

        if( true == get_theme_mod('udetor_blog_tags_show_Date', true )){
            $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
            $time_string = sprintf( $time_string,
                esc_attr( get_the_date( 'c' ) ),
                esc_html( get_the_date() ),
                esc_attr( get_the_modified_date( 'c' ) ),
                esc_html( get_the_modified_date() )
            );
            $posted_on = sprintf(
                _x( ' on %s', 'post date', 'udetor' ),
                '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
            );

            echo '<span class="posted-on"> <i class="fa fa-calendar"></i>' . $posted_on . '</span>';
        }
        if(true == get_theme_mod('udetor_blog_tags_show_category', true )){
            $categories_list = get_the_category_list( esc_html__( ', ', 'udetor' ) );
            if ( $categories_list  ) {
                printf( '<span class="categories-links">'. wp_kses(__(' <i class="fa fa-folder-open"></i> ', 'udetor'), array('i' => array('class' => array()))).' '. esc_html__( '%1$s', 'udetor' ) . '</span>', $categories_list );
            }
        }

        if(true == get_theme_mod('udetor_blog_tags_show_comment_number', true )){
            if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
            echo '<span class="comments-link">'. wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
            comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );
            echo '</span>';
            }
        }
        
        if ( has_tag() ){
          echo '<span class="tags-links">'. wp_kses(__(' <i class="fa fa-tags"></i> ', 'udetor'), array('i' => array('class' => array())));
          printf( esc_html__('%1$s', 'udetor'), get_the_tag_list( '', ' ' ) );
          echo '</span>';
        }
    }


    /**
     * Prints HTML with meta information for the categories, tags and comments.
     */
    public static function udetor_entry_footer() {
        // Hide category and tag text for pages.
        if ( 'post' === get_post_type() ) {
            /* translators: used between list items, there is a space after the comma */
            $categories_list = get_the_category_list( esc_html__( ', ', 'udetor' ) );
            if ( $categories_list && self::udetor_categorized_blog() ) {
                printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'udetor' ) . '</span>', $categories_list ); // WPCS: XSS OK.
            }
            
            /* translators: used between list items, there is a space after the comma */
            $tags_list = get_the_tag_list( '', esc_html__( ', ', 'udetor' ) );
            if ( $tags_list ) {
                printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'udetor' ) . '</span>', $tags_list ); 
            }
        }
        
        if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
            echo '<span class="comments-link">';            
            comments_popup_link( sprintf( wp_kses( __( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'udetor' ), array( 'span' => array( 'class' => array() ) ) ), get_the_title() ) );
            echo '</span>';
        }
        
        edit_post_link(
            sprintf(
            /* translators: %s: Name of current post */
                esc_html__( 'Edit %s', 'udetor' ),
                the_title( '<span class="screen-reader-text">"', '"</span>', false )
            ),
            '<span class="edit-link">',
            '</span>'
        );
    }
    
    /**
     * Returns true if a blog has more than 1 category.
     *
     * @return bool
     */
    public static function udetor_categorized_blog() {
        if ( false === ( $all_the_cool_cats = get_transient( 'udetor_categories' ) ) ) {
            // Create an array of all the categories that are attached to posts.
            $all_the_cool_cats = get_categories( array(
                'fields'     => 'ids',
                'hide_empty' => 1,
                // We only need to know if there is more than one category.
                'number'     => 2,
            ) );
            
            // Count the number of categories that are attached to the posts.
            $all_the_cool_cats = count( $all_the_cool_cats );
            
            set_transient( 'udetor_categories', $all_the_cool_cats );
        }
        
        if ( $all_the_cool_cats > 1 ) {
            // This blog has more than 1 category so udetor_categorized_blog should return true.
            return true;
        } else {
            // This blog has only 1 category so udetor_categorized_blog should return false.
            return false;
        }
    }
    
    /**
     * Flush out the transients used in udetor_categorized_blog.
     */
    public static function udetor_category_transient_flusher() {
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }
        // Like, beat it. Dig?
        delete_transient( 'udetor_categories' );
    }

    /**
     * Get option from default and customizer
     */
    public static function udetor_get_options($option)
    {
        return get_theme_mod($option, Udetor_Assets::udetor_default_options($option));
    }

    /**
     * Get post meta
    */
    public static function udetor_get_post_meta($option)
    {
        if ('' === get_post_meta(get_the_ID(), $option, true)) {
            return Udetor_Assets::udetor_default_options($option);
        } else {
            return get_post_meta(get_the_ID(), $option, true);
        }
    }

}