<?php

/**
 * Class Udetor_Template_Helper.
 *
 * @since 0.9.0
 *
 */
if ( ! class_exists( 'Udetor_Template_Helper' ) ) {
	class Udetor_Template_Helper {


        /**
         * Variable to hold the initialization state.
         *
         * @var  boolean
         */
        protected static $initialized = false;

        /**
         * Initialize functions.
         *
         * @return  void
         */
        public static function initialize() {
            // Do nothing if start functions already initialized.
            if ( self::$initialized ) {
                return;
            }

            // State that initialization completed.
            self::$initialized = true;
        }

		/**
		 * Get template path.
		 *
		 * @since 1.3.0
		 */
		private static function get_template_path() {
			return apply_filters( 'udetor_core_template_path', Udetor_Core::get_core_templates_path() );
		}

		/**
		 * Get template part.
		 *
		 * @since 1.3.0
		 *
		 * @param $path
		 * @param $args
		 * @param $render
		 *
		 * @return bool|string
		 */
		public static function template( $path, $args = array(), $render = false ) {
			$template = locate_template( self::get_template_path() . $path );

			if ( ! $template ) {
				$template = Udetor_Core::get_core_templates_path() . $path;
			}

			if ( $render ) {
				return self::render_template( $template, $args );
			}

			return self::get_template( $template, $args );
		}

		/**
		 * Render template.
		 *
		 * @since 0.9.0
		 *
		 * @param $file
		 * @param $args
		 *
		 * @return bool
		 */
		private static function render_template( $file, $args = array() ) {
			if ( ! is_file( $file ) || ! is_readable( $file ) ) {
				return false;
			}

			include $file;

			return true;
		}

		/**
		 * Get template.
		 *
		 * @since 0.9.0
		 *
		 * @param $file
		 * @param $args
		 *
		 * @return bool|string
		 */
		private static function get_template( $file, $args = array() ) {
			if ( ! is_file( $file ) || ! is_readable( $file ) ) {
				return false;
			}

			ob_start();
			include $file;

			return ob_get_clean();
		}
	}
}